/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public final class OSGiFriendlyClassWriter
extends ClassWriter {
    private static final String OBJECT_INTERNAL_NAME = "java/lang/Object";
    private final ClassLoader loader;

    public OSGiFriendlyClassWriter(ClassReader arg0, int arg1, ClassLoader loader) {
        super(arg0, arg1);
        this.loader = loader;
    }

    public OSGiFriendlyClassWriter(int arg0, ClassLoader loader) {
        super(arg0);
        this.loader = loader;
    }

    @Override
    protected final String getCommonSuperClass(String arg0, String arg1) {
        if (arg0.equals(OBJECT_INTERNAL_NAME) || arg1.equals(OBJECT_INTERNAL_NAME)) {
            return OBJECT_INTERNAL_NAME;
        }
        HashSet<String> names = new HashSet<String>();
        names.add(arg0);
        names.add(arg1);
        try {
            boolean bRunning = true;
            boolean aRunning = true;
            String arg00 = arg0;
            String arg11 = arg1;
            while (aRunning || bRunning) {
                if (aRunning) {
                    if ((arg00 = this._getSuperClassName(arg00)) == null) {
                        aRunning = false;
                    } else if (!names.add(arg00)) {
                        return arg00;
                    }
                }
                if (!bRunning) continue;
                if ((arg11 = this._getSuperClassName(arg11)) == null) {
                    bRunning = false;
                    continue;
                }
                if (names.add(arg11)) continue;
                return arg11;
            }
            throw new RuntimeException("No Common Superclass:" + arg0 + " " + arg1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String _getSuperClassName(String classInternalName) throws IOException {
        if (classInternalName.startsWith("java/")) {
            return OBJECT_INTERNAL_NAME;
        }
        InputStream is = this.loader.getResourceAsStream(classInternalName + ".class");
        if (is == null) {
            return null;
        }
        ClassReader cr = new ClassReader(is);
        String superName = cr.getSuperName();
        if (superName == null) {
            return OBJECT_INTERNAL_NAME;
        }
        return superName;
    }
}

