/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.aries.spifly;

import org.osgi.framework.Bundle;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class ProviderPrototypeServiceFactory implements PrototypeServiceFactory {
    private final Class<?> providerClass;

    public ProviderPrototypeServiceFactory(Class<?> cls) {
        providerClass = cls;
    }

    @Override
    public Object getService(Bundle bundle, ServiceRegistration registration) {
        try {
            return providerClass.newInstance();
        } catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class " + providerClass +
                " Does it have a public no-arg constructor?", e);
        }
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        // nothing to do
    }
}
