/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.weld;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Extension;
import org.apache.aries.cdi.spi.CDIContainerInitializer;
import org.apache.aries.cdi.spi.loader.SpiLoader;
import org.apache.aries.cdi.weld.BundleResourcesLoader;
import org.apache.aries.cdi.weld.ContainerDeployment;
import org.apache.aries.cdi.weld.ContainerDeploymentArchive;
import org.apache.aries.cdi.weld.ContainerEnvironment;
import org.apache.aries.cdi.weld.ExtensionMetadata;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.xml.BeansXmlParser;
import org.osgi.framework.BundleContext;

public class WeldCDIContainerInitializer
extends CDIContainerInitializer {
    private volatile BeanDeploymentArchive beanDeploymentArchive;
    private final List<URL> beanDescriptorURLs = new ArrayList<URL>();
    private volatile WeldBootstrap bootstrap;
    private volatile BundleContext clientBundleContext;
    private volatile SpiLoader spiLoader;
    private final Set<Class<?>> beanClasses = new HashSet();
    private final Map<Extension, Map<String, Object>> extensions = new IdentityHashMap<Extension, Map<String, Object>>();
    private final BundleContext weldBundleContext;
    private final Properties properties = new Properties();

    public WeldCDIContainerInitializer(BundleContext bundleContext) {
        this.weldBundleContext = bundleContext;
    }

    public CDIContainerInitializer addBeanClasses(Class<?> ... classes) {
        this.beanClasses.addAll(Arrays.asList(classes));
        return this;
    }

    public CDIContainerInitializer addBeanXmls(URL ... beanXmls) {
        this.beanDescriptorURLs.addAll(Arrays.asList(beanXmls));
        return this;
    }

    public CDIContainerInitializer addExtension(Extension extension, Map<String, Object> properties) {
        this.extensions.put(extension, properties);
        return this;
    }

    public CDIContainerInitializer addProperty(String key, Object value) {
        this.properties.putIfAbsent(key, value);
        return this;
    }

    public CDIContainerInitializer setBundleContext(BundleContext bundleContext) {
        this.clientBundleContext = bundleContext;
        return this;
    }

    public CDIContainerInitializer setClassLoader(SpiLoader spiLoader) {
        this.spiLoader = spiLoader;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoCloseable initialize() {
        Thread currentThread = Thread.currentThread();
        ClassLoader current = currentThread.getContextClassLoader();
        BundleResourcesLoader resourceLoader = new BundleResourcesLoader(Objects.requireNonNull(this.spiLoader), this.weldBundleContext.getBundle());
        try {
            currentThread.setContextClassLoader((ClassLoader)this.spiLoader);
            List<Metadata<Extension>> metaExtensions = this.extensions.entrySet().stream().map(e -> new ExtensionMetadata((Extension)e.getKey(), this.location((Map)e.getValue()))).collect(Collectors.toList());
            BeansXml beansXml = BeansXml.EMPTY_BEANS_XML;
            if (!this.beanDescriptorURLs.isEmpty()) {
                BeansXmlParser beansXmlParser = new BeansXmlParser();
                beansXml = beansXmlParser.parse(this.beanDescriptorURLs);
            }
            String id = this.clientBundleContext.getBundle().toString();
            this.bootstrap = new WeldBootstrap();
            this.beanDeploymentArchive = new ContainerDeploymentArchive(resourceLoader, id, this.beanClasses.stream().map(Class::getName).collect(Collectors.toList()), beansXml);
            ContainerDeployment deployment = new ContainerDeployment(metaExtensions, this.beanDeploymentArchive);
            this.bootstrap.startExtensions(metaExtensions);
            this.bootstrap.startContainer(id, (Environment)new ContainerEnvironment(), (Deployment)deployment);
            this.bootstrap.startInitialization();
            this.bootstrap.deployBeans();
            this.bootstrap.validateBeans();
            this.bootstrap.endInitialization();
            WeldSeContainer weldSeContainer = new WeldSeContainer();
            return weldSeContainer;
        }
        finally {
            currentThread.setContextClassLoader(current);
        }
    }

    private String location(Map<String, Object> extensionProperties) {
        return String.valueOf(extensionProperties.get("service.id"));
    }

    private class WeldSeContainer
    implements AutoCloseable {
        private WeldSeContainer() {
        }

        @Override
        public void close() {
            Thread currentThread = Thread.currentThread();
            ClassLoader current = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader((ClassLoader)Objects.requireNonNull(WeldCDIContainerInitializer.this.spiLoader));
                WeldCDIContainerInitializer.this.bootstrap.shutdown();
            }
            finally {
                currentThread.setContextClassLoader(current);
            }
        }
    }
}

