/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.extension.el.jsp;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.el.ELContextListener;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.module.web.el.WeldELContextListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class ELJSPExtension
implements Extension {
    private static final String CONTEXT_PATH_PREFIX = "(osgi.http.whiteboard.context.path=";
    private static final String DEFAULT_CONTEXT_FILTER = "(osgi.http.whiteboard.context.name=default)";
    private static final String WEB_CONTEXT_PATH = "Web-ContextPath";
    private final Bundle _bundle;
    private String _contextSelect;
    private ServiceRegistration<?> _registration;

    protected ELJSPExtension() {
        this._bundle = null;
    }

    public ELJSPExtension(Bundle bundle) {
        this._bundle = bundle;
    }

    void afterDeploymentValidation(@Observes @Priority(value=3800) AfterDeploymentValidation adv, final BeanManager beanManager) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.description", "Aries CDI - ELResolver Servlet Context Listener");
        ((Dictionary)properties).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)properties).put("osgi.http.whiteboard.context.select", this.getSelectedContext());
        ((Dictionary)properties).put("osgi.http.whiteboard.listener", Boolean.TRUE.toString());
        ((Dictionary)properties).put("service.ranking", 2147483547);
        this._registration = this._bundle.getBundleContext().registerService(ServletContextListener.class, (Object)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent event) {
                ServletContext servletContext = event.getServletContext();
                JspApplicationContext jspApplicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(servletContext);
                jspApplicationContext.addELResolver(beanManager.getELResolver());
                try {
                    jspApplicationContext.addELContextListener((ELContextListener)new WeldELContextListener());
                }
                catch (Exception e) {
                    servletContext.log("Failure registering ELContextListener", (Throwable)e);
                }
            }

            public void contextDestroyed(ServletContextEvent event) {
            }
        }, properties);
    }

    void beforeShutdown(@Observes BeforeShutdown bs) {
        if (this._registration != null) {
            this._registration.unregister();
        }
    }

    private Map<String, Object> getAttributes() {
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        List wires = bundleWiring.getRequiredWires("osgi.extender");
        Map cdiAttributes = Collections.emptyMap();
        for (BundleWire wire : wires) {
            BundleCapability capability = wire.getCapability();
            Map attributes = capability.getAttributes();
            String extender = (String)attributes.get("osgi.extender");
            if (!extender.equals("osgi.cdi")) continue;
            BundleRequirement requirement = wire.getRequirement();
            cdiAttributes = requirement.getAttributes();
            break;
        }
        return cdiAttributes;
    }

    private String getSelectedContext() {
        if (this._contextSelect != null) {
            return this._contextSelect;
        }
        this._contextSelect = this.getSelectedContext0();
        return this._contextSelect;
    }

    private String getSelectedContext0() {
        Map<String, Object> attributes = this.getAttributes();
        if (attributes.containsKey("osgi.http.whiteboard.context.select")) {
            return (String)attributes.get("osgi.http.whiteboard.context.select");
        }
        Dictionary headers = this._bundle.getHeaders();
        if (headers.get(WEB_CONTEXT_PATH) != null) {
            return CONTEXT_PATH_PREFIX + (String)headers.get(WEB_CONTEXT_PATH) + ')';
        }
        return DEFAULT_CONTEXT_FILTER;
    }
}

