/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import name.pachler.nio.file.ClosedWatchServiceException;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.StandardWatchEventKind;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.ext.ExtendedWatchEventKind;
import name.pachler.nio.file.impl.Linux;
import name.pachler.nio.file.impl.LinuxPathWatchKey;
import name.pachler.nio.file.impl.NativeLibLoader;
import name.pachler.nio.file.impl.PathImpl;
import name.pachler.nio.file.impl.PathWatchEvent;
import name.pachler.nio.file.impl.PathWatchKey;
import name.pachler.nio.file.impl.PathWatchService;
import name.pachler.nio.file.impl.Unix;
import name.pachler.nio.file.impl.VoidWatchEvent;

public class LinuxPathWatchService
extends PathWatchService {
    private int inotifyFd = -1;
    private int commandPipeReadFd;
    private int commandPipeWriteFd;
    private Map<Integer, LinuxPathWatchKey> keys = new HashMap<Integer, LinuxPathWatchKey>();
    private Set<PathWatchKey> signalledWatchKeys = new HashSet<PathWatchKey>();
    private Queue<PathWatchKey> pendingWatchKeys = new LinkedList<PathWatchKey>();
    public static final byte CMD_CLOSE = 1;
    public static final byte CMD_NOTIFY = 2;
    boolean hasMasterThread = false;

    private native int translateInotifyEvents(byte[] var1, int var2, int var3);

    private synchronized void inotifyEventHandler(int wd, int mask, int cookie, String name) {
        WatchEvent.Kind<Path> kind;
        LinuxPathWatchKey key = this.keys.get(wd);
        if (key == null) {
            if (wd == -1 && (mask & 0x4000) != 0) {
                for (LinuxPathWatchKey k : this.keys.values()) {
                    k.addWatchEvent(new VoidWatchEvent(StandardWatchEventKind.OVERFLOW));
                    if (this.signalledWatchKeys.contains(k)) continue;
                    this.signalledWatchKeys.add(k);
                    this.pendingWatchKeys.add(k);
                }
            } else if ((mask & 0x8000) == 0) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "no WatchKey found for given watch descriptor {0}", wd);
            }
            return;
        }
        PathImpl path = null;
        if (name != null) {
            path = new PathImpl(new File(name));
        }
        int flags = key.getFlags();
        boolean eventsAdded = false;
        if ((mask & 0x100) != 0) {
            key.addWatchEvent(new PathWatchEvent(StandardWatchEventKind.ENTRY_CREATE, path, 1));
            eventsAdded = true;
        }
        if ((mask & 2) != 0) {
            key.addWatchEvent(new PathWatchEvent(StandardWatchEventKind.ENTRY_MODIFY, path, 1));
            eventsAdded = true;
        }
        if ((mask & 0x200) != 0) {
            key.addWatchEvent(new PathWatchEvent(StandardWatchEventKind.ENTRY_DELETE, path, 1));
            eventsAdded = true;
        }
        if ((mask & 0x80) != 0) {
            kind = (flags & 4) != 0 ? ExtendedWatchEventKind.ENTRY_RENAME_TO : StandardWatchEventKind.ENTRY_CREATE;
            key.addWatchEvent(new PathWatchEvent(kind, path, 1));
            eventsAdded = true;
        }
        if ((mask & 0x40) != 0) {
            kind = (flags & 2) != 0 ? ExtendedWatchEventKind.ENTRY_RENAME_FROM : StandardWatchEventKind.ENTRY_DELETE;
            key.addWatchEvent(new PathWatchEvent(kind, path, 1));
            eventsAdded = true;
        }
        if ((mask & 0x8000) != 0) {
            key.addWatchEvent(new VoidWatchEvent(ExtendedWatchEventKind.KEY_INVALID));
            key.invalidate();
            eventsAdded = true;
        }
        if (eventsAdded && !this.signalledWatchKeys.contains(key)) {
            this.signalledWatchKeys.add(key);
            this.pendingWatchKeys.add(key);
        }
    }

    public LinuxPathWatchService() {
        this.inotifyFd = Linux.inotify_init();
        int[] pipefd = new int[2];
        int pipeResult = Linux.pipe(pipefd);
        this.commandPipeReadFd = pipefd[0];
        this.commandPipeWriteFd = pipefd[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public WatchKey take() throws InterruptedException {
        return this.pollImpl(-1L);
    }

    @Override
    public WatchKey poll() throws InterruptedException {
        return this.pollImpl(0L);
    }

    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException, ClosedWatchServiceException {
        long millis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this.pollImpl(millis);
    }

    @Override
    public synchronized void close() throws IOException {
        int nwritten = Linux.write(this.commandPipeWriteFd, new byte[]{1}, 1);
        if (nwritten == -1) {
            throw new IOException();
        }
        if (!this.hasMasterThread) {
            this.handleCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WatchKey pollImpl(long timeout) throws InterruptedException, ClosedWatchServiceException {
        WatchKey key = null;
        do {
            boolean isMasterThread = false;
            long startTime = System.currentTimeMillis();
            try {
                LinuxPathWatchService linuxPathWatchService = this;
                synchronized (linuxPathWatchService) {
                    block33: {
                        key = this.pendingWatchKeys.poll();
                        if (key == null) break block33;
                        continue;
                    }
                    if (this.inotifyFd == -1) {
                        throw new ClosedWatchServiceException();
                    }
                    boolean bl = isMasterThread = !this.hasMasterThread;
                    if (isMasterThread) {
                        this.hasMasterThread = true;
                    } else if (timeout > 0L) {
                        this.wait(timeout);
                    }
                }
                if (!isMasterThread) continue;
                Object fds = new int[]{this.inotifyFd, this.commandPipeReadFd};
                int n = Unix.select((int[])fds, null, null, timeout);
                if (n == -1) {
                    if (Linux.errno() == Linux.EINTR) {
                        throw new InterruptedException();
                    }
                    this.closeImpl();
                    throw new ClosedWatchServiceException();
                }
                byte[] buffer = new byte[4096];
                int bufferSize = 0;
                int bufferPos = 0;
                if (fds[0] != this.inotifyFd) continue;
                int nread = Linux.read(this.inotifyFd, buffer, buffer.length);
                if (nread == -1) {
                    int err = Linux.errno();
                    if (err == Linux.EINTR) {
                        throw new InterruptedException();
                    }
                    this.closeImpl();
                    throw new ClosedWatchServiceException();
                }
                bufferSize = nread;
                LinuxPathWatchService linuxPathWatchService2 = this;
                synchronized (linuxPathWatchService2) {
                    this.translateInotifyEvents(buffer, bufferPos, bufferSize);
                }
            }
            finally {
                LinuxPathWatchService linuxPathWatchService = this;
                synchronized (linuxPathWatchService) {
                    if (isMasterThread) {
                        int n = Unix.ioctl_FIONREAD(this.commandPipeReadFd);
                        if (n > 0) {
                            this.handleCommand();
                        }
                        this.hasMasterThread = false;
                        this.notify();
                    }
                    if (key == null) {
                        key = this.pendingWatchKeys.poll();
                    }
                }
                if (timeout != -1L) {
                    long endTime = System.currentTimeMillis();
                    long timeDifference = endTime - startTime;
                    timeout = Math.max(0L, timeout - timeDifference);
                }
            }
        } while (timeout != 0L && key == null);
        return key;
    }

    @Override
    public synchronized PathWatchKey register(Path path, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier[] modifiers) throws IOException {
        String pathname;
        int watchDescriptor;
        int supportedFlags;
        if (this.inotifyFd == -1) {
            throw new ClosedWatchServiceException();
        }
        PathImpl pathImpl = this.checkAndCastToPathImpl(path);
        int flags = this.makeFlagMask(kinds, modifiers);
        if ((flags & ~(supportedFlags = 8318)) != 0) {
            throw new UnsupportedOperationException("The given watch event kind or modifier is not supported by this WatchService");
        }
        int mask = 0;
        if (0 != (flags & 8)) {
            mask |= 0x100;
            if (0 == (flags & 4)) {
                mask |= 0x80;
            }
        }
        if (0 != (flags & 0x10)) {
            mask |= 0x200;
            if (0 == (flags & 2)) {
                mask |= 0x40;
            }
        }
        if (0 != (flags & 0x20)) {
            mask |= 2;
        }
        if (0 != (flags & 2)) {
            mask |= 0x40;
        }
        if (0 != (flags & 4)) {
            mask |= 0x80;
        }
        if ((watchDescriptor = Linux.inotify_add_watch(this.inotifyFd, pathname = pathImpl.getFile().getAbsolutePath(), mask)) == -1) {
            String msg = Linux.strerror(Linux.errno());
            throw new IOException("error registering the path with the native OS: " + msg);
        }
        LinuxPathWatchKey key = this.keys.get(watchDescriptor);
        if (key == null) {
            key = new LinuxPathWatchKey(this, pathImpl, flags);
            this.keys.put(watchDescriptor, key);
        } else {
            key.setFlags(flags);
        }
        return key;
    }

    @Override
    synchronized void cancel(PathWatchKey pathWatchKey) {
        if (this.inotifyFd == -1) {
            throw new ClosedWatchServiceException();
        }
        int wd = -1;
        Set<Map.Entry<Integer, LinuxPathWatchKey>> entrySet = this.keys.entrySet();
        Iterator<Map.Entry<Integer, LinuxPathWatchKey>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, LinuxPathWatchKey> entry = iterator.next();
            if (entry.getValue() != pathWatchKey) continue;
            wd = entry.getKey();
            if ((pathWatchKey.getFlags() & 0x40) != 0) {
                this.inotifyEventHandler(wd, 32768, 0, null);
            }
            pathWatchKey.invalidate();
            iterator.remove();
            break;
        }
        if (pathWatchKey == null) {
            return;
        }
        int result = Linux.inotify_rm_watch(this.inotifyFd, wd);
        if (result == -1) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "inotify_rm_watch() failed: {0}", Linux.strerror(Linux.errno()));
        }
    }

    @Override
    public synchronized boolean reset(PathWatchKey pathWatchKey) {
        if (!pathWatchKey.isValid()) {
            return false;
        }
        if (pathWatchKey.hasPendingWatchEvents()) {
            if (!this.hasMasterThread) {
                this.pendingWatchKeys.add(pathWatchKey);
            }
        } else {
            this.signalledWatchKeys.remove(pathWatchKey);
        }
        return true;
    }

    private synchronized void handleCommand() {
        byte[] b = new byte[1];
        Unix.read(this.commandPipeReadFd, b, 1);
        byte command = b[0];
        switch (command) {
            case 1: {
                this.closeImpl();
            }
        }
    }

    private synchronized void closeImpl() {
        for (PathWatchKey pathWatchKey : this.keys.values()) {
            pathWatchKey.invalidate();
        }
        this.keys.clear();
        this.signalledWatchKeys.clear();
        this.pendingWatchKeys.clear();
        Unix.close(this.inotifyFd);
        this.inotifyFd = -1;
        Unix.close(this.commandPipeReadFd);
        this.commandPipeReadFd = -1;
        Unix.close(this.commandPipeWriteFd);
        this.commandPipeWriteFd = -1;
    }

    static {
        NativeLibLoader.loadLibrary("jpathwatch-native");
    }
}

