/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.push.util;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.liferay.mobile.push.exception.PushNotificationReceiverException;
import com.liferay.mobile.push.exception.UnavailableGooglePlayServicesException;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleServices {
    public String getMessageType(Context context, Intent intent) {
        return this.getInstance(context).getMessageType(intent);
    }

    public JSONObject getPushNotification(Context context, Intent intent) throws PushNotificationReceiverException {
        String messageType = this.getMessageType(context, intent);
        if (!"gcm".equals(messageType)) {
            throw new PushNotificationReceiverException("Unknown message type" + messageType);
        }
        Bundle extras = intent.getExtras();
        if (extras == null || extras.isEmpty()) {
            throw new PushNotificationReceiverException("Push notification body is empty.");
        }
        String payload = extras.getString("payload", null);
        if (payload == null) {
            throw new PushNotificationReceiverException("Push notification without payload.");
        }
        try {
            JSONObject pushNotification = new JSONObject(payload);
            return pushNotification;
        }
        catch (JSONException je) {
            throw new PushNotificationReceiverException(je);
        }
    }

    public String getRegistrationId(Context context, String senderId) throws IOException {
        return this.getInstance(context).register(new String[]{senderId});
    }

    public void isGooglePlayServicesAvailable(Context context) throws UnavailableGooglePlayServicesException {
        int result = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        if (result != 0) {
            String message = GooglePlayServicesUtil.getErrorString((int)result);
            throw new UnavailableGooglePlayServicesException(message);
        }
    }

    protected GoogleCloudMessaging getInstance(Context context) {
        return GoogleCloudMessaging.getInstance((Context)context);
    }
}

