/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.push;

import android.content.Context;
import com.liferay.mobile.android.callback.Callback;
import com.liferay.mobile.android.callback.typed.JSONObjectCallback;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.service.SessionImpl;
import com.liferay.mobile.push.PushNotificationsDeviceServiceWrapper;
import com.liferay.mobile.push.PushSubscriber;
import com.liferay.mobile.push.task.GoogleCloudMessagingAsyncTask;
import com.liferay.mobile.push.util.GoogleServices;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Push {
    public static final String FIREBASE = "firebase";
    protected OnFailure onFailure;
    protected OnPushNotification onPushNotification;
    protected OnSuccess onSuccess;
    private GoogleServices _googleServices = new GoogleServices();
    private int _portalVersion = 6200;
    private Session _session;
    private PushSubscriber _subscriber;

    public static Push with(Session session) {
        return new Push(session);
    }

    public Push onFailure(OnFailure onFailure) {
        this.onFailure = onFailure;
        return this;
    }

    public Push onPushNotification(OnPushNotification onPushNotification) {
        this._subscriber.subscribe();
        this.onPushNotification = onPushNotification;
        return this;
    }

    public Push onSuccess(OnSuccess onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public void register(Context context, String senderId) throws Exception {
        try {
            this._subscriber.subscribe();
            GoogleCloudMessagingAsyncTask task = new GoogleCloudMessagingAsyncTask(context, senderId, this._googleServices);
            task.execute(new Object[0]);
        }
        catch (Exception e) {
            this._subscriber.unsubscribe();
            throw e;
        }
    }

    public void register(String registrationId) throws Exception {
        this.getService().addPushNotificationsDevice(registrationId, FIREBASE);
    }

    public void send(List<Long> toUserIds, JSONObject pushNotification) throws Exception {
        JSONArray toUserIdsJSONArray = new JSONArray();
        for (long toUserId : toUserIds) {
            toUserIdsJSONArray.put(toUserId);
        }
        this.getService().sendPushNotification(toUserIdsJSONArray, pushNotification.toString());
    }

    public void send(long toUserId, JSONObject pushNotification) throws Exception {
        ArrayList<Long> toUserIds = new ArrayList<Long>();
        toUserIds.add(toUserId);
        this.send(toUserIds, pushNotification);
    }

    public void unregister(String registrationId) throws Exception {
        this.getService().deletePushNotificationsDevice(registrationId);
    }

    public void unsubscribe() {
        this._subscriber.unsubscribe();
    }

    public Push withPortalVersion(int portalVersion) {
        this._portalVersion = portalVersion;
        return this;
    }

    protected Push(Session session) {
        this._session = new SessionImpl(session);
        this._session.setHeaders(session.getHeaders());
        this._subscriber = new PushSubscriber(this);
        this._session.setCallback((Callback)new JSONObjectCallback(){

            public void onFailure(Exception e) {
                if (Push.this.onFailure != null) {
                    Push.this.onFailure.onFailure(e);
                }
            }

            public void onSuccess(JSONObject jsonObject) {
                if (Push.this.onSuccess != null) {
                    Push.this.onSuccess.onSuccess(jsonObject);
                }
            }
        });
    }

    protected PushNotificationsDeviceServiceWrapper getService() {
        return new PushNotificationsDeviceServiceWrapper(this._session, this._portalVersion);
    }

    protected void setGoogleServices(GoogleServices googleServices) {
        this._googleServices = googleServices;
    }

    public static interface OnSuccess {
        public void onSuccess(JSONObject var1);
    }

    public static interface OnPushNotification {
        public void onPushNotification(JSONObject var1);
    }

    public static interface OnFailure {
        public void onFailure(Exception var1);
    }
}

