/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.push.task;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.liferay.mobile.push.bus.BusUtil;
import com.liferay.mobile.push.exception.UnavailableGooglePlayServicesException;
import com.liferay.mobile.push.util.GoogleServices;

public class GoogleCloudMessagingAsyncTask
extends AsyncTask<Object, Void, String> {
    private static final String _TAG = GoogleCloudMessagingAsyncTask.class.getSimpleName();
    private Context _context;
    private Exception _exception;
    private GoogleServices _googleServices;
    private String _senderId;

    public GoogleCloudMessagingAsyncTask(Context context, String senderId, GoogleServices googleServices) throws UnavailableGooglePlayServicesException {
        this._context = context.getApplicationContext();
        this._senderId = senderId;
        this._googleServices = googleServices;
        this._googleServices.isGooglePlayServicesAvailable(this._context);
    }

    public String doInBackground(Object ... params) {
        String registrationId = null;
        try {
            registrationId = this._googleServices.getRegistrationId(this._context, this._senderId);
        }
        catch (Exception e) {
            Log.e((String)_TAG, (String)"Could not retrieve request token.", (Throwable)e);
            this._exception = e;
            this.cancel(true);
        }
        return registrationId;
    }

    protected void onCancelled() {
        BusUtil.post(this._exception);
    }

    protected void onPostExecute(String registrationId) {
        BusUtil.post(registrationId);
    }
}

