/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.push.bus;

import android.util.Log;
import com.squareup.otto.Bus;
import com.squareup.otto.ThreadEnforcer;

public class BusUtil {
    private static final String _TAG = BusUtil.class.getSimpleName();
    private static Bus _bus;

    public static void post(Object event) {
        BusUtil.getInstance().post(event);
    }

    public static void subscribe(Object object) {
        BusUtil.getInstance().register(object);
    }

    public static void unsubscribe(Object object) {
        try {
            BusUtil.getInstance().unregister(object);
        }
        catch (IllegalArgumentException iae) {
            Log.w((String)_TAG, (String)"Could not unsubscribe.", (Throwable)iae);
        }
    }

    protected static Bus getInstance() {
        if (_bus == null) {
            _bus = new Bus(ThreadEnforcer.ANY);
        }
        return _bus;
    }
}

