/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.push;

import com.liferay.mobile.push.Push;
import com.liferay.mobile.push.bus.BusUtil;
import com.squareup.otto.Subscribe;
import org.json.JSONObject;

public class PushSubscriber {
    protected Push push;

    public PushSubscriber(Push push) {
        this.push = push;
    }

    @Subscribe
    public void onFailure(Exception e) {
        this.unsubscribe();
        if (this.push.onFailure != null) {
            this.push.onFailure.onFailure(e);
        }
    }

    @Subscribe
    public void onPushNotification(JSONObject pushNotification) {
        if (this.push.onPushNotification != null) {
            this.push.onPushNotification.onPushNotification(pushNotification);
        }
    }

    @Subscribe
    public void register(String registrationId) throws Exception {
        this.unsubscribe();
        this.push.register(registrationId);
    }

    public void subscribe() {
        BusUtil.subscribe(this);
    }

    public void unsubscribe() {
        BusUtil.unsubscribe(this);
    }
}

