/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.util;

import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.http.Method;
import com.liferay.mobile.android.http.Request;
import com.liferay.mobile.android.http.Response;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.v7.portal.PortalService;

public class PortalVersionUtil {
    public static int getPortalVersion(Session session) throws Exception {
        int version = PortalVersionUtil.getBuilderNumberHeader(session);
        if (version == -1) {
            try {
                version = PortalVersionUtil.getBuilderNumber(session, "api/jsonws");
            }
            catch (Exception e) {
                version = PortalVersionUtil.getBuilderNumber(session, "api/secure/jsonws");
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getBuilderNumber(Session session, String jsonWSPath) throws Exception {
        HttpUtil.setJSONWSPath(jsonWSPath);
        PortalService service = new PortalService(session);
        int version = -1;
        try {
            version = service.getBuildNumber();
        }
        finally {
            HttpUtil.setJSONWSPath("api/jsonws");
        }
        return version;
    }

    protected static int getBuilderNumberHeader(Session session) throws Exception {
        Request request = new Request(Method.HEAD, session.getHeaders(), session.getServer(), null, session.getConnectionTimeout(), true);
        Response response = HttpUtil.send(request);
        String portalHeader = response.getHeaders().get("Liferay-Portal");
        if (portalHeader == null) {
            return -1;
        }
        int indexOfBuild = portalHeader.indexOf("Build");
        if (indexOfBuild == -1) {
            return -1;
        }
        String buildNumber = portalHeader.substring(indexOfBuild + 6, indexOfBuild + 10);
        return Integer.valueOf(buildNumber);
    }
}

