/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth.oauth2;

import com.liferay.mobile.android.auth.SessionCallback;
import com.liferay.mobile.android.auth.oauth2.OAuth2Authentication;
import com.liferay.mobile.android.exception.ServerException;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.service.SessionImpl;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class TokenRequester {
    public static OkHttpClient client = new OkHttpClient();
    private String tokenUrl;
    private Session session;
    private String clientId;
    private String clientSecret;
    private List<String> scopes;
    private Map<String, String> parameters;
    private static final String GRANT_TYPE = "grant_type";
    private static final String GRANT_TYPE_PASSWORD = "password";
    private static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    private static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";

    public TokenRequester(Session session, String tokenUrl, String clientId, String clientSecret, List<String> scopes, Map<String, String> parameters) {
        this.session = session;
        this.tokenUrl = tokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scopes = scopes;
        this.parameters = parameters;
    }

    public static Map<String, String> parametersUsernameAndPassword(String username, String password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("username", username);
        parameters.put(GRANT_TYPE_PASSWORD, password);
        parameters.put(GRANT_TYPE, GRANT_TYPE_PASSWORD);
        return parameters;
    }

    public static Map<String, String> parametersClientCredentials() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(GRANT_TYPE, GRANT_TYPE_CLIENT_CREDENTIALS);
        return parameters;
    }

    public static Map<String, String> parametersRefresh(String refreshToken) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(GRANT_TYPE_REFRESH_TOKEN, refreshToken);
        parameters.put(GRANT_TYPE, GRANT_TYPE_REFRESH_TOKEN);
        return parameters;
    }

    public Session send(final SessionCallback callback) throws Exception {
        OkHttpClient client = TokenRequester.client.clone();
        FormEncodingBuilder formBody = new FormEncodingBuilder();
        Request.Builder requestBuilder = new Request.Builder().url(this.tokenUrl);
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            formBody.add(parameter.getKey(), parameter.getValue());
        }
        if (!this.scopes.isEmpty()) {
            formBody.add("scope", this.spaceSeparatedScopes());
        }
        if (this.clientSecret != null && !this.clientSecret.isEmpty()) {
            requestBuilder.header("Authorization", Credentials.basic((String)this.clientId, (String)this.clientSecret));
        } else {
            formBody.add("client_id", this.clientId);
        }
        RequestBody body = formBody.build();
        Request request = requestBuilder.post(body).build();
        Call call = client.newCall(request);
        if (callback == null) {
            return this.parseResponse(call.execute(), this.session, this.clientId, this.clientSecret);
        }
        call.enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                callback.onFailure(e);
            }

            public void onResponse(Response response) {
                try {
                    callback.onSuccess(TokenRequester.this.parseResponse(response, TokenRequester.this.session, TokenRequester.this.clientId, TokenRequester.this.clientSecret));
                }
                catch (Exception ex) {
                    callback.onFailure(ex);
                }
            }
        });
        return null;
    }

    private Session parseResponse(Response response, Session session, String clientId, String clientSecret) throws Exception {
        if (!response.isSuccessful()) {
            throw new ServerException(response.message());
        }
        OAuth2Authentication auth = this.parseJsonToken(response, session, clientId, clientSecret);
        SessionImpl oauth2Session = new SessionImpl(session);
        oauth2Session.setAuthentication(auth);
        return oauth2Session;
    }

    private OAuth2Authentication parseJsonToken(Response response, Session session, String clientId, String clientSecret) throws Exception {
        try {
            JSONObject jsonObject = new JSONObject(response.body().string());
            String accessToken = jsonObject.getString("access_token");
            long expirationTime = jsonObject.getLong("expires_in");
            String scope = jsonObject.getString("scope");
            String refreshToken = jsonObject.optString(GRANT_TYPE_REFRESH_TOKEN);
            long expirationDate = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) + expirationTime;
            List<String> scopes = Arrays.asList(scope.split(" "));
            return this.createOrUpdateAuthentication(session, accessToken, refreshToken, scopes, expirationDate, clientId, clientSecret);
        }
        catch (JSONException e) {
            throw new ServerException("Invalid json");
        }
    }

    private OAuth2Authentication createOrUpdateAuthentication(Session session, String accessToken, String refreshToken, List<String> scopes, long expirationDate, String clientId, String clientSecret) {
        if (session.getAuthentication() != null && session.getAuthentication() instanceof OAuth2Authentication) {
            OAuth2Authentication auth = (OAuth2Authentication)session.getAuthentication();
            auth.setAccessToken(accessToken);
            auth.setRefreshToken(refreshToken);
            auth.setScope(scopes);
            auth.setAccessTokenExpirationDate(expirationDate);
            auth.setClientId(clientId);
            auth.setClientSecret(clientSecret);
            return auth;
        }
        return new OAuth2Authentication(accessToken, refreshToken, scopes, expirationDate, clientId, clientSecret);
    }

    private boolean shouldAuthenticateRequest() {
        String grantType = this.parameters.get(GRANT_TYPE);
        return GRANT_TYPE_CLIENT_CREDENTIALS.equals(grantType) || GRANT_TYPE_PASSWORD.equals(grantType);
    }

    private String spaceSeparatedScopes() {
        StringBuilder builder = new StringBuilder();
        for (String scope : this.scopes) {
            builder.append(scope).append(" ");
        }
        return builder.toString();
    }
}

