/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth.basic;

import com.liferay.mobile.android.auth.basic.BasicAuthentication;
import com.liferay.mobile.android.http.Request;
import java.util.Map;

public class CookieAuthentication
extends BasicAuthentication {
    public static final int COOKIE_EXPIRATION_TIME = 900;
    protected String authToken;
    protected int cookieExpirationTime;
    protected String cookieHeader;
    protected long lastCookieRefresh;
    protected boolean shouldHandleExpiration;

    public CookieAuthentication(String authToken, String cookieHeader, String username, String password) {
        this(authToken, cookieHeader, username, password, true, 900, System.currentTimeMillis());
    }

    public CookieAuthentication(String authToken, String cookieHeader, String username, String password, boolean shouldHandleExpiration, int cookieExpirationTime, long lastCookieRefresh) {
        super(username, password);
        this.authToken = authToken;
        this.cookieHeader = cookieHeader;
        this.shouldHandleExpiration = shouldHandleExpiration;
        this.cookieExpirationTime = cookieExpirationTime;
        this.lastCookieRefresh = lastCookieRefresh;
    }

    @Override
    public void authenticate(Request request) {
        Map<String, String> headers = request.getHeaders();
        headers.put("Cookie", "COOKIE_SUPPORT=true; " + this.cookieHeader);
        headers.put("X-CSRF-Token", this.authToken);
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public int getCookieExpirationTime() {
        return this.cookieExpirationTime;
    }

    public String getCookieHeader() {
        return this.cookieHeader;
    }

    public long getLastCookieRefresh() {
        return this.lastCookieRefresh;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public void setCookieExpirationTime(int cookieExpirationTime) {
        this.cookieExpirationTime = cookieExpirationTime;
    }

    public void setCookieHeader(String cookieHeader) {
        this.cookieHeader = cookieHeader;
    }

    public void setLastCookieRefresh(long lastCookieRefresh) {
        this.lastCookieRefresh = lastCookieRefresh;
    }

    public void setShouldHandleExpiration(boolean shouldHandleExpiration) {
        this.shouldHandleExpiration = shouldHandleExpiration;
    }

    public boolean shouldHandleExpiration() {
        return this.shouldHandleExpiration;
    }
}

