/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth;

import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.auth.basic.CookieAuthentication;
import com.liferay.mobile.android.exception.AuthenticationException;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.service.SessionImpl;
import com.liferay.mobile.android.util.Validator;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okio.Buffer;
import okio.BufferedSink;

public class CookieSignIn {
    public static OkHttpClient client = new OkHttpClient();
    protected CookieManager cookieManager;
    protected String password;
    protected Session session;
    protected String username;
    protected static final Map<String, Authenticator> authenticators = new HashMap<String, Authenticator>();

    public static void registerAuthenticatorForServer(String server, Authenticator authenticator) {
        authenticators.put(server, authenticator);
    }

    public static Session signIn(Session session) throws Exception {
        CookieSignIn cookieSignIn = new CookieSignIn(session);
        Call call = cookieSignIn.signIn();
        Response response = call.execute();
        return CookieSignIn.parseResponse(response, session.getServer(), cookieSignIn.cookieManager, CookieSignIn.getCookieAuthentication(session.getAuthentication()));
    }

    public static void signIn(Session session, CookieCallback callback) {
        CookieSignIn.signIn(session, callback, null);
    }

    public static void signIn(Session session, CookieCallback callback, Authenticator authenticator) {
        try {
            CookieSignIn cookieSignIn = new CookieSignIn(session);
            Call call = cookieSignIn.signIn();
            Callback requestCallback = CookieSignIn.getCallback(session.getServer(), callback, cookieSignIn.cookieManager, CookieSignIn.getCookieAuthentication(session.getAuthentication()));
            call.enqueue(requestCallback);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    protected static Callback getCallback(final String server, final CookieCallback callback, final CookieManager cookieManager, final CookieAuthentication authentication) {
        return new Callback(){

            public void onFailure(Request request, IOException ioe) {
                callback.onFailure(ioe);
            }

            public void onResponse(Response response) {
                try {
                    Session session = CookieSignIn.parseResponse(response, server, cookieManager, authentication);
                    callback.onSuccess(session);
                }
                catch (Exception e) {
                    callback.onFailure(e);
                }
            }
        };
    }

    protected static CookieAuthentication getCookieAuthentication(Authentication authentication) {
        return (CookieAuthentication)authentication;
    }

    protected static String getHttpCookies(CookieStore cookieStore) {
        StringBuilder cookies = new StringBuilder();
        for (HttpCookie cookie : cookieStore.getCookies()) {
            cookies.append(cookie);
            cookies.append(";");
        }
        return cookies.toString();
    }

    protected static String parseAuthToken(String body) throws AuthenticationException, IOException {
        Pattern tokenPattern = Pattern.compile(".*Liferay.authToken\\s*=\\s*[\"'](.{8})[\"'].*");
        Matcher matcher = tokenPattern.matcher(body);
        if (!matcher.find()) {
            throw new AuthenticationException("Cookie invalid or empty");
        }
        return matcher.group(1);
    }

    protected static Session parseResponse(Response response, String server, CookieManager cookieManager, CookieAuthentication authentication) throws Exception {
        if (response.code() == 500) {
            throw new AuthenticationException("Cookie invalid or empty");
        }
        String body = response.body().string();
        String authToken = CookieSignIn.parseAuthToken(body);
        String cookieHeader = CookieSignIn.getHttpCookies(cookieManager.getCookieStore());
        if (Validator.isNotNull(cookieHeader)) {
            authentication.setAuthToken(authToken);
            authentication.setCookieHeader(cookieHeader);
            authentication.setLastCookieRefresh(System.currentTimeMillis());
            return new SessionImpl(server, authentication);
        }
        throw new AuthenticationException("Cookie invalid or empty");
    }

    protected CookieSignIn(Session session) {
        this.session = session;
    }

    protected String getBody(String username, String password) throws IOException {
        RequestBody formBody = new FormEncodingBuilder().add("login", username).add("password", password).add("rememberMe", "true").build();
        Buffer buffer = new Buffer();
        formBody.writeTo((BufferedSink)buffer);
        return buffer.readUtf8();
    }

    protected Request.Builder getBuilder(Session session, String username, String password) throws IOException {
        Request.Builder builder = new Request.Builder();
        MediaType contentType = MediaType.parse((String)"application/x-www-form-urlencoded");
        builder.post(RequestBody.create((MediaType)contentType, (String)this.getBody(username, password)));
        builder.addHeader("Cookie", "COOKIE_SUPPORT=true;");
        builder.url(this.getLoginURL(session.getServer()));
        return builder;
    }

    protected String getLoginURL(String server) {
        if (server.contains("/api/jsonws/invoke")) {
            server = server.substring(0, server.indexOf("/api/jsonws/invoke"));
        }
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        return server + "c/portal/login";
    }

    protected Call signIn() throws Exception {
        if (!(this.session.getAuthentication() instanceof CookieAuthentication)) {
            throw new Exception("Can't sign in if authentication implementation is not CookieAuthentication");
        }
        CookieAuthentication cookieAuthentication = CookieSignIn.getCookieAuthentication(this.session.getAuthentication());
        this.username = cookieAuthentication.getUsername();
        this.password = cookieAuthentication.getPassword();
        this.cookieManager = new CookieManager();
        this.cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        OkHttpClient client = CookieSignIn.client.clone();
        Authenticator authenticator = authenticators.get(this.session.getServer());
        if (authenticator != null) {
            client.setAuthenticator(authenticator);
        }
        client.setCookieHandler((CookieHandler)this.cookieManager);
        client.setFollowRedirects(true);
        Request.Builder builder = this.getBuilder(this.session, this.username, this.password);
        return client.newCall(builder.build());
    }

    public static interface CookieCallback {
        public void onSuccess(Session var1);

        public void onFailure(Exception var1);
    }
}

