/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http.file;

import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.auth.basic.DigestAuthentication;
import com.liferay.mobile.android.callback.file.FileProgressCallback;
import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.util.Validator;

public class DownloadUtil {
    public static void downloadWebDAVFile(Session session, int portalVersion, String groupFriendlyURL, String folderPath, String fileTitle, FileProgressCallback callback) throws Exception {
        Authentication auth = session.getAuthentication();
        if (auth != null && !(auth instanceof DigestAuthentication)) {
            throw new Exception("Can't download file if authentication implementation is not DigestAuthentication");
        }
        String url = DownloadUtil.getWebDAVFileURL(session, portalVersion, groupFriendlyURL, folderPath, fileTitle);
        HttpUtil.download(session, url, callback);
    }

    protected static String getWebDAVFileURL(Session session, int portalVersion, String groupFriendlyURL, String folderPath, String fileTitle) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(session.getServer());
        if (portalVersion < 6200) {
            sb.append("/api/secure");
        }
        sb.append("/webdav");
        sb.append(DownloadUtil.prependSlash(groupFriendlyURL));
        sb.append("/document_library");
        sb.append(DownloadUtil.prependSlash(folderPath));
        sb.append(DownloadUtil.prependSlash(fileTitle));
        return HttpUtil.encodeURLPath(sb.toString());
    }

    protected static String prependSlash(String string) {
        if (Validator.isNotNull(string) && !string.startsWith("/")) {
            return "/" + string;
        }
        return string;
    }
}

