/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth;

import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.auth.CookieSignIn;
import com.liferay.mobile.android.auth.basic.CookieAuthentication;
import com.liferay.mobile.android.http.Request;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.service.SessionImpl;
import com.squareup.okhttp.Authenticator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CookieExpirationHandler {
    protected static final Map<String, Authenticator> authenticators = new HashMap<String, Authenticator>();
    protected static final Lock lock = new ReentrantLock();

    public static void registerAuthenticatorForServer(String server, Authenticator authenticator) {
        authenticators.put(server, authenticator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session reloadSessionIfNeeded(Request request, final CookieSignIn.CookieCallback callback) throws Exception {
        final SessionImpl session = new SessionImpl(request.getURL(), request.getAuthentication());
        if (CookieExpirationHandler.shouldCheckCookieExpiration(request.getAuthentication())) {
            CookieAuthentication authentication = (CookieAuthentication)request.getAuthentication();
            lock.lock();
            if (CookieExpirationHandler.shouldRefreshCookie(authentication.getLastCookieRefresh(), authentication.getCookieExpirationTime())) {
                Authenticator authenticator = authenticators.get(session.getServer());
                if (callback == null) {
                    try {
                        Session cookieSession = CookieSignIn.signIn((Session)session, authenticator);
                        request.setAuthentication(cookieSession.getAuthentication());
                        Session session2 = cookieSession;
                        return session2;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                CookieSignIn.signIn(session, new CookieSignIn.CookieCallback(){

                    @Override
                    public void onSuccess(Session cookieSession) {
                        session.setAuthentication(cookieSession.getAuthentication());
                        lock.unlock();
                        callback.onSuccess(session);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        lock.unlock();
                        callback.onFailure(e);
                    }
                }, authenticator);
                return null;
            }
            lock.unlock();
        }
        if (callback != null) {
            callback.onSuccess(session);
            return null;
        }
        return session;
    }

    protected static boolean shouldCheckCookieExpiration(Authentication authentication) {
        CookieAuthentication cookieAuthentication;
        return authentication instanceof CookieAuthentication && (cookieAuthentication = (CookieAuthentication)authentication).shouldHandleExpiration();
    }

    protected static boolean shouldRefreshCookie(long lastCookieRefresh, int cookieExpirationTime) {
        long now = System.currentTimeMillis();
        long deltaTime = TimeUnit.MILLISECONDS.toSeconds(now - lastCookieRefresh);
        return deltaTime > (long)cookieExpirationTime;
    }
}

