/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http;

import com.liferay.mobile.android.exception.AuthenticationException;
import com.liferay.mobile.android.exception.RedirectException;
import com.liferay.mobile.android.exception.ServerException;
import com.liferay.mobile.android.util.Validator;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Response {
    private com.squareup.okhttp.Response _response;

    public Response() {
        this(null);
    }

    public Response(com.squareup.okhttp.Response response) {
        this._response = response;
    }

    public String getBody() throws Exception {
        String body = this._response.body().string();
        this.checkStatusCode();
        this.checkPortalException(body);
        return body;
    }

    public InputStream getBodyAsStream() throws Exception {
        this.checkStatusCode();
        return this._response.body().byteStream();
    }

    public Map<String, String> getHeaders() {
        Map headers = this._response.headers().toMultimap();
        HashMap map = new HashMap();
        for (Map.Entry header : headers.entrySet()) {
            map.put(header.getKey(), ((List)header.getValue()).get(0));
        }
        return Collections.unmodifiableMap(map);
    }

    public int getStatusCode() {
        return this._response.code();
    }

    protected void checkPortalException(String json) throws ServerException {
        try {
            JSONObject jsonObj;
            if (this.isJSONObject(json) && (jsonObj = new JSONObject(json)).has("exception")) {
                String message = jsonObj.getString("exception");
                String detail = jsonObj.optString("message", null);
                JSONObject error = jsonObj.optJSONObject("error");
                if (error != null) {
                    message = error.getString("type");
                    detail = error.getString("message");
                }
                if (message != null && message.equals("java.lang.SecurityException")) {
                    throw new AuthenticationException(message, detail);
                }
                throw new ServerException(message, detail);
            }
        }
        catch (JSONException je) {
            throw new ServerException(je);
        }
    }

    protected void checkStatusCode() throws ServerException {
        int status = this.getStatusCode();
        if (status == 301 || status == 302 || status == 303 || status == 307) {
            String url = this.getHeaders().get("Location");
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            throw new RedirectException(url);
        }
        if (status == 401) {
            throw new AuthenticationException("Authentication failed.", "HTTP Status Code 401");
        }
        if (status != 200 && status != 500) {
            throw new ServerException("Request failed. Response code: " + status);
        }
    }

    protected boolean isJSONObject(String json) {
        return Validator.isNotNull(json) && json.startsWith("{");
    }
}

