/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth;

import com.liferay.mobile.android.auth.basic.BasicAuthentication;
import com.liferay.mobile.android.auth.basic.CookieAuthentication;
import com.liferay.mobile.android.exception.AuthenticationException;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.service.SessionImpl;
import com.liferay.mobile.android.util.Validator;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import okio.Buffer;
import okio.BufferedSink;

public class CookieSignIn {
    protected static final String AUTH_TOKEN = "Liferay.authToken=\"";
    protected static final int TOKEN_LENGTH = 8;
    protected Authenticator authenticator;
    protected CookieManager cookieManager;
    protected String password;
    protected Session session;
    protected String username;

    public static Session signIn(Session session) throws Exception {
        Authenticator authenticator = null;
        return CookieSignIn.signIn(session, authenticator);
    }

    public static void signIn(Session session, CookieCallback callback) {
        CookieSignIn.signIn(session, callback, null);
    }

    public static Session signIn(Session session, Authenticator authenticator) throws Exception {
        CookieSignIn cookieSignIn = new CookieSignIn(session, authenticator);
        Call call = cookieSignIn.signIn();
        Response response = call.execute();
        return CookieSignIn.parseResponse(response, session.getServer(), cookieSignIn.cookieManager, cookieSignIn.username, cookieSignIn.password);
    }

    public static void signIn(Session session, CookieCallback callback, Authenticator authenticator) {
        try {
            CookieSignIn cookieSignIn = new CookieSignIn(session, authenticator);
            Call call = cookieSignIn.signIn();
            Callback requestCallback = CookieSignIn.getCallback(session.getServer(), callback, cookieSignIn.cookieManager, cookieSignIn.username, cookieSignIn.password);
            call.enqueue(requestCallback);
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    protected static Callback getCallback(final String server, final CookieCallback callback, final CookieManager cookieManager, final String username, final String password) {
        return new Callback(){

            public void onFailure(Request request, IOException ioe) {
                callback.onFailure(ioe);
            }

            public void onResponse(Response response) {
                try {
                    Session session = CookieSignIn.parseResponse(response, server, cookieManager, username, password);
                    callback.onSuccess(session);
                }
                catch (Exception e) {
                    callback.onFailure(e);
                }
            }
        };
    }

    protected static String getHttpCookies(CookieStore cookieStore) {
        StringBuilder cookies = new StringBuilder();
        for (HttpCookie cookie : cookieStore.getCookies()) {
            cookies.append(cookie);
            cookies.append(";");
        }
        return cookies.toString();
    }

    protected static Session parseResponse(Response response, String server, CookieManager cookieManager, String username, String password) throws Exception {
        if (response.code() == 500) {
            throw new AuthenticationException("Cookie invalid or empty");
        }
        String body = response.body().string();
        Integer position = body.indexOf(AUTH_TOKEN) + AUTH_TOKEN.length();
        String authToken = body.substring(position, position + 8);
        String cookieHeader = CookieSignIn.getHttpCookies(cookieManager.getCookieStore());
        if (Validator.isNotNull(cookieHeader)) {
            CookieAuthentication authentication = new CookieAuthentication(authToken, cookieHeader, username, password);
            return new SessionImpl(server, authentication);
        }
        throw new AuthenticationException("Cookie invalid or empty");
    }

    protected String getBody(String username, String password) throws IOException {
        RequestBody formBody = new FormEncodingBuilder().add("login", username).add("password", password).build();
        Buffer buffer = new Buffer();
        formBody.writeTo((BufferedSink)buffer);
        return buffer.readUtf8();
    }

    protected Request.Builder getBuilder(Session session, String username, String password) throws IOException {
        Request.Builder builder = new Request.Builder();
        MediaType contentType = MediaType.parse((String)"application/x-www-form-urlencoded");
        builder.post(RequestBody.create((MediaType)contentType, (String)this.getBody(username, password)));
        builder.addHeader("Cookie", "COOKIE_SUPPORT=true;");
        builder.url(this.getLoginURL(session.getServer()));
        return builder;
    }

    protected String getLoginURL(String server) {
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        return server + "c/portal/login";
    }

    protected Call signIn() throws Exception {
        if (!(this.session.getAuthentication() instanceof BasicAuthentication)) {
            throw new Exception("Can't sign in if authentication implementation is not BasicAuthentication");
        }
        BasicAuthentication basicAuthentication = (BasicAuthentication)this.session.getAuthentication();
        this.username = basicAuthentication.getUsername();
        this.password = basicAuthentication.getPassword();
        this.cookieManager = new CookieManager();
        this.cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        OkHttpClient client = new OkHttpClient();
        if (this.authenticator != null) {
            client.setAuthenticator(this.authenticator);
        }
        client.setCookieHandler((CookieHandler)this.cookieManager);
        client.setFollowRedirects(true);
        Request.Builder builder = this.getBuilder(this.session, this.username, this.password);
        return client.newCall(builder.build());
    }

    private CookieSignIn(Session session, Authenticator authenticator) {
        this.session = session;
        this.authenticator = authenticator;
    }

    public static interface CookieCallback {
        public void onSuccess(Session var1);

        public void onFailure(Exception var1);
    }
}

