/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.util;

import android.util.Base64;
import com.liferay.mobile.android.callback.file.FileProgressCallback;
import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.http.Response;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.util.Validator;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;

public class PortraitUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadPortrait(Session session, String portraitURL, final OutputStream os, String modifiedDate) throws Exception {
        String lastModified = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (Validator.isNotNull(modifiedDate)) {
                headers.put("If-Modified-Since", modifiedDate);
            }
            session.setHeaders(headers);
            Response response = HttpUtil.download(session, portraitURL, new FileProgressCallback(){

                @Override
                public void onBytes(byte[] bytes) {
                    try {
                        os.write(bytes);
                    }
                    catch (IOException ioe) {
                        this.setCancelled(true);
                    }
                }

                @Override
                public void onProgress(int totalBytes) {
                }
            });
            lastModified = response.getHeaders().get("Last-Modified");
        }
        finally {
            PortraitUtil.close(os);
        }
        return lastModified;
    }

    public static String downloadPortrait(Session session, String portraitURL, OutputStream os) throws Exception {
        return PortraitUtil.downloadPortrait(session, portraitURL, os, null);
    }

    public static String downloadPortrait(Session session, String portraitURL, String filePath) throws Exception {
        return PortraitUtil.downloadPortrait(session, portraitURL, filePath, null);
    }

    public static String downloadPortrait(Session session, String portraitURL, String filePath, String modifiedDate) throws Exception {
        return PortraitUtil.downloadPortrait(session, portraitURL, new FileOutputStream(filePath), modifiedDate);
    }

    public static String getPortraitURL(Session session, boolean male, long portraitId, String uuid) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(session.getServer());
        sb.append("/image/user_");
        if (male) {
            sb.append("male");
        } else {
            sb.append("female");
        }
        sb.append("_portrait?img_id=");
        sb.append(portraitId);
        PortraitUtil.appendToken(sb, uuid);
        return sb.toString();
    }

    protected static void appendToken(StringBuilder sb, String uuid) throws Exception {
        String token;
        block4: {
            if (Validator.isNull(uuid)) {
                return;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(uuid.getBytes());
            byte[] bytes = digest.digest();
            token = null;
            try {
                token = Base64.encodeToString((byte[])bytes, (int)2);
            }
            catch (RuntimeException re) {
                if (!"Stub!".equals(re.getMessage())) break block4;
                token = DatatypeConverter.printBase64Binary((byte[])bytes);
            }
        }
        if (token != null) {
            sb.append("&img_id_token=");
            sb.append(URLEncoder.encode(token, "UTF8"));
        }
    }

    protected static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

