/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http.client;

import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.callback.Callback;
import com.liferay.mobile.android.http.Method;
import com.liferay.mobile.android.http.Request;
import com.liferay.mobile.android.http.Response;
import com.liferay.mobile.android.http.client.HttpClient;
import com.liferay.mobile.android.http.file.InputStreamBody;
import com.liferay.mobile.android.http.file.UploadData;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class OkHttpClientImpl
implements HttpClient {
    protected OkHttpClient client = new OkHttpClient();

    @Override
    public void cancel(Object tag) {
        this.client.cancel(tag);
    }

    @Override
    public String encodeURL(String url) {
        return HttpUrl.parse((String)url).toString();
    }

    @Override
    public Response send(Request request) throws Exception {
        Request.Builder builder = new Request.Builder();
        Method method = request.getMethod();
        if (method == Method.POST) {
            String body = (String)request.getBody();
            if (body != null) {
                MediaType type = MediaType.parse((String)"application/json; charset=utf-8");
                builder.post(RequestBody.create((MediaType)type, (String)body));
            }
        } else if (method == Method.HEAD) {
            builder.head();
        }
        return this.send(builder, request);
    }

    @Override
    public Response upload(Request request) throws Exception {
        Request.Builder builder = new Request.Builder();
        builder.post(this.getUploadBody(request));
        return this.send(builder, request);
    }

    protected void addHeaders(Request.Builder builder, Request request) {
        Map<String, String> headers = request.getHeaders();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                builder.addHeader(header.getKey(), header.getValue());
            }
        }
    }

    protected void authenticate(OkHttpClient client, Request request) throws Exception {
        Authentication authentication = request.getAuthentication();
        if (authentication != null) {
            if (authentication instanceof Authenticator) {
                client.setAuthenticator((Authenticator)authentication);
            } else {
                authentication.authenticate(request);
            }
        }
    }

    protected OkHttpClient getClient(int connectionTimeout) {
        OkHttpClient clone = this.client.clone();
        clone.setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        clone.setReadTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        clone.setWriteTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        clone.setFollowRedirects(false);
        return clone;
    }

    protected RequestBody getUploadBody(Request request) {
        JSONObject body = (JSONObject)request.getBody();
        Object tag = request.getTag();
        MultipartBuilder builder = new MultipartBuilder().type(MultipartBuilder.FORM);
        Iterator it = body.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = body.opt(key);
            if (value instanceof UploadData) {
                UploadData data = (UploadData)value;
                InputStreamBody requestBody = new InputStreamBody(data, tag);
                builder.addFormDataPart(key, data.getFileName(), (RequestBody)requestBody);
                continue;
            }
            builder.addFormDataPart(key, value.toString());
        }
        return builder.build();
    }

    protected Response send(Request.Builder builder, Request request) throws Exception {
        builder = builder.url(request.getURL());
        builder.tag(request.getTag());
        OkHttpClient client = this.getClient(request.getConnectionTimeout());
        this.authenticate(client, request);
        this.addHeaders(builder, request);
        Call call = client.newCall(builder.build());
        Callback callback = request.getCallback();
        if (callback == null) {
            return new Response(call.execute());
        }
        this.sendAsync(call, callback);
        return null;
    }

    protected void sendAsync(Call call, final Callback callback) {
        call.enqueue(new com.squareup.okhttp.Callback(){

            public void onFailure(com.squareup.okhttp.Request request, IOException ioe) {
                callback.doFailure(ioe);
            }

            public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                callback.inBackground(new Response(response));
            }
        });
    }
}

