/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http;

import com.liferay.mobile.android.exception.ServerException;
import com.liferay.mobile.android.http.entity.CountingHttpEntity;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.task.UploadAsyncTask;
import com.liferay.mobile.android.util.Validator;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtil {
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";

    public static HttpClient getClient(Session session) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)client.getParams(), (int)session.getConnectionTimeout());
        return client;
    }

    public static HttpPost getPost(Session session, String URL) {
        HttpPost post = new HttpPost(URL);
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(session.getUsername(), session.getPassword());
        Header authorization = BasicScheme.authenticate((Credentials)credentials, (String)"UTF-8", (boolean)false);
        post.addHeader(authorization);
        return post;
    }

    public static String getResponseString(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        return EntityUtils.toString((HttpEntity)entity);
    }

    public static String getURL(Session session, String path) {
        StringBuilder sb = new StringBuilder();
        String server = session.getServer();
        sb.append(server);
        if (!server.endsWith("/")) {
            sb.append("/");
        }
        sb.append("api/jsonws");
        sb.append(path);
        return sb.toString();
    }

    public static JSONArray post(Session session, JSONArray commands) throws Exception {
        HttpClient client = HttpUtil.getClient(session);
        HttpPost post = HttpUtil.getPost(session, HttpUtil.getURL(session, "/invoke"));
        post.setEntity((HttpEntity)new StringEntity(commands.toString(), "UTF-8"));
        HttpResponse response = client.execute((HttpUriRequest)post);
        String json = HttpUtil.getResponseString(response);
        HttpUtil.handleServerException(response, json);
        return new JSONArray(json);
    }

    public static JSONArray post(Session session, JSONObject command) throws Exception {
        JSONArray commands = new JSONArray();
        commands.put((Object)command);
        return HttpUtil.post(session, commands);
    }

    public static Object upload(Session session, JSONObject command, UploadAsyncTask task) throws Exception {
        String path = (String)command.keys().next();
        JSONObject parameters = command.getJSONObject(path);
        HttpClient client = HttpUtil.getClient(session);
        HttpPost post = HttpUtil.getPost(session, HttpUtil.getURL(session, path));
        Object entity = HttpUtil.getMultipartEntity(parameters);
        if (task != null) {
            entity = new CountingHttpEntity((HttpEntity)entity, task);
        }
        post.setEntity((HttpEntity)entity);
        HttpResponse response = client.execute((HttpUriRequest)post);
        String json = HttpUtil.getResponseString(response);
        HttpUtil.handleServerException(response, json);
        if (HttpUtil.isJSONObject(json)) {
            return new JSONObject(json);
        }
        return new JSONArray(json);
    }

    protected static MultipartEntity getMultipartEntity(JSONObject parameters) throws Exception {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        Charset charset = Charset.forName("UTF-8");
        Iterator it = parameters.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = parameters.get(key);
            Object contentBody = value instanceof InputStreamBody ? (InputStreamBody)value : new StringBody(value.toString(), charset);
            entity.addPart(key, (ContentBody)contentBody);
        }
        return entity;
    }

    protected static void handleServerException(HttpResponse response, String json) throws ServerException {
        int status = response.getStatusLine().getStatusCode();
        if (status == 401) {
            throw new ServerException("Authentication failed.");
        }
        if (status != 200) {
            throw new ServerException("Request failed. Response code: " + status);
        }
        try {
            JSONObject jsonObj;
            if (HttpUtil.isJSONObject(json) && (jsonObj = new JSONObject(json)).has("exception")) {
                String message = jsonObj.getString("exception");
                throw new ServerException(message);
            }
        }
        catch (JSONException je) {
            throw new ServerException(je);
        }
    }

    protected static boolean isJSONObject(String json) {
        return Validator.isNotNull(json) && json.startsWith("{");
    }
}

