/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http;

import android.util.Log;
import com.liferay.mobile.android.exception.ServerException;
import com.liferay.mobile.android.service.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtil {
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    private static final String _CLASS_NAME = HttpUtil.class.getSimpleName();
    private static final Map<String, Integer> _versions = new HashMap<String, Integer>();

    public static HttpClient getClient(Session session) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)client.getParams(), (int)session.getConnectionTimeout());
        return client;
    }

    public static int getPortalVersion(Session session) {
        return HttpUtil.getPortalVersion(session.getServer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPortalVersion(String url) {
        Integer version = null;
        try {
            version = _versions.get(url);
            if (version != null) {
                int n = version;
                return n;
            }
            DefaultHttpClient client = new DefaultHttpClient();
            HttpHead head = new HttpHead(url);
            HttpResponse response = client.execute((HttpUriRequest)head);
            Header portalHeader = response.getFirstHeader("Liferay-Portal");
            if (portalHeader == null) {
                version = -1;
                int n = version;
                return n;
            }
            String portalField = portalHeader.getValue();
            int indexOfBuild = portalField.indexOf("Build");
            if (indexOfBuild == -1) {
                version = -1;
            } else {
                String buildNumber = portalField.substring(indexOfBuild + 6, indexOfBuild + 10);
                version = Integer.valueOf(buildNumber);
            }
        }
        catch (Exception e) {
            Log.e((String)_CLASS_NAME, (String)"Couldn't get portal version", (Throwable)e);
            version = -1;
        }
        finally {
            _versions.put(url, version);
        }
        return version;
    }

    public static HttpPost getPost(Session session) {
        HttpPost post = new HttpPost(HttpUtil.getURL(session));
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(session.getUsername(), session.getPassword());
        Header authorization = BasicScheme.authenticate((Credentials)credentials, (String)"UTF-8", (boolean)false);
        post.addHeader(authorization);
        return post;
    }

    public static String getResponseString(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        return EntityUtils.toString((HttpEntity)entity);
    }

    public static String getURL(Session session) {
        StringBuilder sb = new StringBuilder();
        String server = session.getServer();
        sb.append(server);
        if (!server.endsWith("/")) {
            sb.append("/");
        }
        sb.append("api/jsonws/invoke");
        return sb.toString();
    }

    public static JSONArray post(Session session, JSONArray commands) throws Exception {
        HttpClient client = HttpUtil.getClient(session);
        HttpPost post = HttpUtil.getPost(session);
        post.setEntity((HttpEntity)new StringEntity(commands.toString()));
        HttpResponse response = client.execute((HttpUriRequest)post);
        String json = HttpUtil.getResponseString(response);
        return HttpUtil.handleResponse(response, json);
    }

    public static JSONArray post(Session session, JSONObject command) throws Exception {
        JSONArray commands = new JSONArray();
        commands.put((Object)command);
        return HttpUtil.post(session, commands);
    }

    protected static JSONArray handleResponse(HttpResponse response, String json) throws ServerException {
        int status = response.getStatusLine().getStatusCode();
        if (status == 401) {
            throw new ServerException("Authentication failed.");
        }
        if (status != 200) {
            throw new ServerException("Request failed. Response code: " + status);
        }
        try {
            if (json != null) {
                if (json.startsWith("{")) {
                    JSONObject jsonObj = new JSONObject(json);
                    if (jsonObj.has("exception")) {
                        String message = jsonObj.getString("exception");
                        throw new ServerException(message);
                    }
                    throw new ServerException("Unexpected return type: " + json.toString());
                }
                if (json.startsWith("[")) {
                    return new JSONArray(json);
                }
            }
        }
        catch (JSONException je) {
            throw new ServerException(je);
        }
        return null;
    }
}

