/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http.file;

import com.liferay.mobile.android.http.file.FileProgressCallback;
import com.liferay.mobile.android.http.file.FileTransferUtil;
import com.liferay.mobile.android.http.file.MultiOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.client.methods.HttpPostHC4;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.InputStreamBody;

public class UploadData
extends InputStreamBody {
    protected FileProgressCallback callback;
    protected OutputStream os;
    protected HttpPostHC4 request;

    public UploadData(InputStream is, ContentType mimeType, String fileName, FileProgressCallback callback) {
        super(is, mimeType, fileName);
        this.callback = callback;
    }

    public UploadData(InputStream is, OutputStream extraOutputStream, String fileName, FileProgressCallback callback) {
        this(is, fileName, callback);
        this.os = extraOutputStream;
    }

    public UploadData(InputStream is, String fileName, FileProgressCallback callback) {
        this(is, ContentType.DEFAULT_BINARY, fileName, callback);
    }

    public void setRequest(HttpPostHC4 request) {
        this.request = request;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("OutputStream may not be null");
        }
        InputStream is = this.getInputStream();
        this.os = this.os != null ? new MultiOutputStream(outputStream, this.os) : outputStream;
        try {
            FileTransferUtil.transfer((AbstractExecutionAwareRequest)this.request, is, this.os, this.callback);
        }
        finally {
            FileTransferUtil.close(is);
        }
    }
}

