/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.util;

import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.v62.portal.PortalService;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class PortalVersionUtil {
    public static int getPortalVersion(Session session) throws Exception {
        int version = PortalVersionUtil.getBuilderNumberHeader(session.getServer());
        if (version == -1) {
            try {
                version = PortalVersionUtil.getBuilderNumber(session, "api/jsonws");
            }
            catch (Exception e) {
                version = PortalVersionUtil.getBuilderNumber(session, "api/secure/jsonws");
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getBuilderNumber(Session session, String jsonWSPath) throws Exception {
        HttpUtil.setJSONWSPath(jsonWSPath);
        PortalService service = new PortalService(session);
        int version = -1;
        try {
            version = service.getBuildNumber();
        }
        finally {
            HttpUtil.setJSONWSPath("api/jsonws");
        }
        return version;
    }

    protected static int getBuilderNumberHeader(String url) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpHead head = new HttpHead(url);
        HttpResponse response = client.execute((HttpUriRequest)head);
        Header portalHeader = response.getFirstHeader("Liferay-Portal");
        if (portalHeader == null) {
            return -1;
        }
        String portalField = portalHeader.getValue();
        int indexOfBuild = portalField.indexOf("Build");
        if (indexOfBuild == -1) {
            return -1;
        }
        String buildNumber = portalField.substring(indexOfBuild + 6, indexOfBuild + 10);
        return Integer.valueOf(buildNumber);
    }
}

