/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http.file;

import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.http.file.UploadData;
import com.liferay.mobile.android.service.Session;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPostHC4;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.json.JSONArray;
import org.json.JSONObject;

public class UploadUtil {
    public static JSONArray upload(Session session, JSONObject command) throws Exception {
        String path = (String)command.keys().next();
        JSONObject parameters = command.getJSONObject(path);
        HttpClient client = HttpUtil.getClient(session);
        HttpPostHC4 request = HttpUtil.getHttpPost(session, HttpUtil.getURL(session, path));
        HttpEntity entity = UploadUtil.getMultipartEntity(request, parameters);
        request.setEntity(entity);
        HttpResponse response = client.execute((HttpUriRequest)request);
        String json = HttpUtil.getResponseString(response);
        HttpUtil.handleServerError((HttpRequest)request, response, json);
        return new JSONArray("[" + json + "]");
    }

    protected static HttpEntity getMultipartEntity(HttpPostHC4 request, JSONObject parameters) throws Exception {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        ContentType contentType = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
        Iterator it = parameters.keys();
        while (it.hasNext()) {
            Object contentBody;
            String key = (String)it.next();
            Object value = parameters.get(key);
            if (value instanceof UploadData) {
                UploadData wrapper = (UploadData)((Object)value);
                wrapper.setRequest(request);
                contentBody = wrapper;
            } else {
                contentBody = new StringBody(value.toString(), contentType);
            }
            builder.addPart(key, (ContentBody)contentBody);
        }
        return builder.build();
    }
}

