/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http.file;

import com.liferay.mobile.android.http.file.FileProgressCallback;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;

public class FileTransferUtil {
    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void transfer(AbstractExecutionAwareRequest request, InputStream is, OutputStream os, FileProgressCallback callback) throws IOException {
        int count;
        byte[] data = new byte[4096];
        while ((count = is.read(data)) != -1 && !FileTransferUtil.isCancelled(callback)) {
            os.write(data, 0, count);
            if (callback == null) continue;
            callback.increment(count);
        }
        os.flush();
        if (FileTransferUtil.isCancelled(callback)) {
            request.abort();
        }
    }

    protected static boolean isCancelled(FileProgressCallback callback) {
        return callback != null && callback.isCancelled();
    }
}

