/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http.file;

import android.net.Uri;
import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.auth.basic.DigestAuthentication;
import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.http.file.FileProgressCallback;
import com.liferay.mobile.android.http.file.FileTransferUtil;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.util.Validator;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGetHC4;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class DownloadUtil {
    protected static URLEncoder encoder = new URLEncoder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(Session session, OutputStream os, String URL2, FileProgressCallback callback) throws Exception {
        HttpClientBuilder clientBuilder = HttpUtil.getClientBuilder(session);
        HttpGetHC4 request = HttpUtil.getHttpGet(session, URL2);
        CloseableHttpResponse response = clientBuilder.build().execute((HttpUriRequest)request);
        HttpUtil.checkStatusCode((HttpRequest)request, (HttpResponse)response);
        InputStream is = response.getEntity().getContent();
        try {
            FileTransferUtil.transfer((AbstractExecutionAwareRequest)request, is, os, callback);
        }
        finally {
            FileTransferUtil.close(is);
        }
    }

    public static void downloadWebDAVFile(Session session, int portalVersion, String groupFriendlyURL, String folderPath, String fileTitle, OutputStream os, FileProgressCallback callback) throws Exception {
        Authentication auth = session.getAuthentication();
        if (auth != null && !(auth instanceof DigestAuthentication)) {
            throw new Exception("Can't download file if authentication implementation is not DigestAuthentication");
        }
        String URL2 = DownloadUtil.getWebDAVFileURL(session, portalVersion, groupFriendlyURL, folderPath, fileTitle);
        DownloadUtil.download(session, os, URL2, callback);
    }

    public static String getWebDAVFileURL(Session session, int portalVersion, String groupFriendlyURL, String folderPath, String fileTitle) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(session.getServer());
        if (portalVersion < 6200) {
            sb.append("/api/secure");
        }
        sb.append("/webdav");
        sb.append(DownloadUtil.prependSlash(groupFriendlyURL));
        sb.append("/document_library");
        StringBuilder webdavPath = new StringBuilder();
        webdavPath.append(DownloadUtil.prependSlash(folderPath));
        webdavPath.append(DownloadUtil.prependSlash(fileTitle));
        sb.append(encoder.encode(webdavPath.toString()));
        return sb.toString();
    }

    protected static String prependSlash(String string) {
        if (Validator.isNotNull(string) && !string.startsWith("/")) {
            return "/" + string;
        }
        return string;
    }

    protected static class URLEncoder {
        private final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";

        protected URLEncoder() {
        }

        public String encode(String path) throws Exception {
            return Uri.encode((String)path, (String)"@#&=*+-_.,:!?()/~'%");
        }
    }
}

