/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.service;

import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.http.file.UploadData;
import com.liferay.mobile.android.http.file.UploadUtil;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.task.ServiceAsyncTask;
import com.liferay.mobile.android.task.UploadAsyncTask;
import com.liferay.mobile.android.task.callback.AsyncTaskCallback;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionImpl
implements Session {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected Authentication authentication;
    protected AsyncTaskCallback callback;
    protected int connectionTimeout;
    protected String server;

    public SessionImpl(Session session) {
        this(session.getServer(), session.getAuthentication(), session.getConnectionTimeout(), session.getCallback());
    }

    public SessionImpl(String server) {
        this(server, null, null);
    }

    public SessionImpl(String server, AsyncTaskCallback callback) {
        this(server, null, callback);
    }

    public SessionImpl(String server, Authentication authentication) {
        this(server, authentication, null);
    }

    public SessionImpl(String server, Authentication authentication, AsyncTaskCallback callback) {
        this(server, authentication, 15000, callback);
    }

    public SessionImpl(String server, Authentication authentication, int connectionTimeout, AsyncTaskCallback callback) {
        this.server = server;
        this.authentication = authentication;
        this.connectionTimeout = connectionTimeout;
        this.callback = callback;
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public AsyncTaskCallback getCallback() {
        return this.callback;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public JSONArray invoke(JSONObject command) throws Exception {
        if (this.callback != null) {
            ServiceAsyncTask task = new ServiceAsyncTask(this, this.callback);
            task.execute(command);
            return null;
        }
        return HttpUtil.post((Session)this, command);
    }

    @Override
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public void setCallback(AsyncTaskCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    public void setServer(String server) {
        this.server = server;
    }

    @Override
    public JSONArray upload(JSONObject command) throws Exception {
        if (!this.hasUploadData(command)) {
            return this.invoke(command);
        }
        if (this.callback != null) {
            UploadAsyncTask task = new UploadAsyncTask(this, this.callback);
            task.execute(new JSONObject[]{command});
            return null;
        }
        return UploadUtil.upload(this, command);
    }

    protected boolean hasUploadData(JSONObject command) throws JSONException {
        if (command.length() == 0) {
            return false;
        }
        String first = command.names().getString(0);
        JSONObject params = command.getJSONObject(first);
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!(params.get(key) instanceof UploadData)) continue;
            return true;
        }
        return false;
    }
}

