/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.util.download;

import android.net.Uri;
import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.auth.basic.DigestAuthentication;
import com.liferay.mobile.android.http.HttpUtil;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.util.Validator;
import com.liferay.mobile.android.util.download.DownloadProgressCallback;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class DownloadUtil {
    protected static URLEncoder encoder = new URLEncoder();

    public static void download(HttpClient httpClient, HttpGet request, OutputStream os, DownloadProgressCallback callback) throws Exception {
        int count;
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        HttpUtil.checkStatusCode((HttpRequest)request, response);
        InputStream is = response.getEntity().getContent();
        int totalBytes = 0;
        byte[] data = new byte[8192];
        while ((count = is.read(data)) != -1 && !DownloadUtil.isCancelled(callback)) {
            os.write(data, 0, count);
            if (callback == null) continue;
            callback.onProgress(totalBytes += count);
        }
        if (DownloadUtil.isCancelled(callback)) {
            request.abort();
        }
    }

    public static void downloadFile(Session session, int portalVersion, String groupFriendlyURL, String folderPath, String fileTitle, OutputStream os, DownloadProgressCallback callback) throws Exception {
        Authentication auth = session.getAuthentication();
        if (auth != null && !(auth instanceof DigestAuthentication)) {
            throw new Exception("Can't download file if authentication implementation is not DigestAuthentication");
        }
        String URL2 = DownloadUtil.getDownloadURL(session, portalVersion, groupFriendlyURL, folderPath, fileTitle);
        HttpClientBuilder clientBuilder = HttpUtil.getClientBuilder(session);
        HttpGet request = new HttpGet(URL2);
        DownloadUtil.download((HttpClient)clientBuilder.build(), request, os, callback);
    }

    public static String getDownloadURL(Session session, int portalVersion, String groupFriendlyURL, String folderPath, String fileTitle) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(session.getServer());
        if (portalVersion < 6200) {
            sb.append("/api/secure");
        }
        sb.append("/webdav");
        sb.append(DownloadUtil.prependSlash(groupFriendlyURL));
        sb.append("/document_library");
        StringBuilder webdavPath = new StringBuilder();
        webdavPath.append(DownloadUtil.prependSlash(folderPath));
        webdavPath.append(DownloadUtil.prependSlash(fileTitle));
        sb.append(encoder.encode(webdavPath.toString()));
        return sb.toString();
    }

    protected static boolean isCancelled(DownloadProgressCallback callback) {
        return callback != null && callback.isCancelled();
    }

    protected static String prependSlash(String string) {
        if (Validator.isNotNull(string) && !string.startsWith("/")) {
            return "/" + string;
        }
        return string;
    }

    protected static class URLEncoder {
        private final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";

        protected URLEncoder() {
        }

        public String encode(String path) throws Exception {
            return Uri.encode((String)path, (String)"@#&=*+-_.,:!?()/~'%");
        }
    }
}

