/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth;

public enum SignInMethod {
    USER_ID,
    EMAIL,
    SCREEN_NAME;


    public static SignInMethod fromUsername(String username) {
        if (SignInMethod.isEmail(username)) {
            return EMAIL;
        }
        if (SignInMethod.isUserId(username)) {
            return USER_ID;
        }
        return SCREEN_NAME;
    }

    protected static boolean isEmail(String username) {
        return username.contains("@");
    }

    protected static boolean isUserId(String username) {
        boolean isUserId = true;
        try {
            Long.parseLong(username);
        }
        catch (Exception e) {
            isUserId = false;
        }
        return isUserId;
    }
}

