/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.util;

import android.util.Log;
import com.liferay.mobile.android.service.Session;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class PortalVersionUtil {
    private static final String _CLASS_NAME = PortalVersionUtil.class.getName();
    private static final Map<String, Integer> _versions = new HashMap<String, Integer>();

    public static int getPortalVersion(Session session) {
        return PortalVersionUtil.getPortalVersion(session.getServer());
    }

    public static int getPortalVersion(String url) {
        Integer version;
        try {
            version = _versions.get(url);
            if (version != null) {
                return version;
            }
            DefaultHttpClient client = new DefaultHttpClient();
            HttpHead head = new HttpHead(url);
            HttpResponse response = client.execute((HttpUriRequest)head);
            Header portalHeader = response.getFirstHeader("Liferay-Portal");
            if (portalHeader == null) {
                return -1;
            }
            String portalField = portalHeader.getValue();
            int indexOfBuild = portalField.indexOf("Build");
            if (indexOfBuild == -1) {
                return -1;
            }
            String buildNumber = portalField.substring(indexOfBuild + 6, indexOfBuild + 10);
            version = Integer.valueOf(buildNumber);
            _versions.put(url, version);
        }
        catch (Exception e) {
            Log.e((String)_CLASS_NAME, (String)"Couldn't get portal version", (Throwable)e);
            return -1;
        }
        return version;
    }
}

