/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http.file;

import com.liferay.mobile.android.callback.file.FileProgressCallback;
import com.liferay.mobile.android.http.HttpUtil;
import com.squareup.okhttp.internal.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class FileProgressUtil {
    public static boolean isCancelled(FileProgressCallback callback) {
        return callback != null && callback.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transfer(InputStream is, FileProgressCallback callback, Object tag, BufferedSink sink) throws IOException {
        Source source = null;
        try {
            source = Okio.source((InputStream)is);
            Buffer os = new Buffer();
            while (source.read(os, 2048L) != -1L && !FileProgressUtil.isCancelled(callback)) {
                byte[] bytes = os.readByteArray();
                if (sink != null) {
                    sink.write(bytes);
                }
                if (callback == null) continue;
                callback.onBytes(bytes);
                callback.increment(bytes.length);
            }
            if (FileProgressUtil.isCancelled(callback)) {
                HttpUtil.cancel(tag);
            }
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }
}

