/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.http.client;

import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.auth.SessionCallback;
import com.liferay.mobile.android.auth.refresh.AuthenticationRefreshHandler;
import com.liferay.mobile.android.auth.refresh.AuthenticationRefreshHandlerFactory;
import com.liferay.mobile.android.callback.Callback;
import com.liferay.mobile.android.http.Method;
import com.liferay.mobile.android.http.Request;
import com.liferay.mobile.android.http.Response;
import com.liferay.mobile.android.http.client.HttpClient;
import com.liferay.mobile.android.http.file.InputStreamBody;
import com.liferay.mobile.android.http.file.UploadData;
import com.liferay.mobile.android.service.Session;
import com.liferay.mobile.android.service.SessionImpl;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class OkHttpClientImpl
implements HttpClient {
    protected AuthenticationRefreshHandlerFactory refreshHandlerFactory = new AuthenticationRefreshHandlerFactory();
    protected OkHttpClient client = new OkHttpClient();

    @Override
    public void setRefreshHandlerFactory(AuthenticationRefreshHandlerFactory refreshHandlerFactory) {
        this.refreshHandlerFactory = refreshHandlerFactory;
    }

    @Override
    public void cancel(Object tag) {
        this.client.cancel(tag);
    }

    @Override
    public String encodeURL(String url) {
        return HttpUrl.parse((String)url).toString();
    }

    @Override
    public Response send(Request request) throws Exception {
        Request.Builder builder = new Request.Builder();
        Method method = request.getMethod();
        if (method == Method.POST) {
            String body = (String)request.getBody();
            if (body != null) {
                MediaType type = MediaType.parse((String)"application/json; charset=utf-8");
                builder.post(RequestBody.create((MediaType)type, (String)body));
            }
        } else if (method == Method.HEAD) {
            builder.head();
        }
        return this.send(builder, request);
    }

    @Override
    public Response upload(Request request) throws Exception {
        Request.Builder builder = new Request.Builder();
        builder.post(this.getUploadBody(request));
        return this.send(builder, request);
    }

    protected void addHeaders(Request.Builder builder, Request request) {
        Map<String, String> headers = request.getHeaders();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                builder.addHeader(header.getKey(), header.getValue());
            }
        }
    }

    protected void setProtocols(OkHttpClient client, Request request) {
        List<Protocol> protocols = request.getProtocols();
        if (protocols != null && !protocols.isEmpty()) {
            client.setProtocols(protocols);
        }
    }

    protected void authenticate(OkHttpClient client, Request request) throws Exception {
        Authentication authentication = request.getAuthentication();
        if (authentication != null) {
            if (authentication instanceof Authenticator) {
                client.setAuthenticator((Authenticator)authentication);
            } else {
                authentication.authenticate(request);
            }
        }
    }

    protected Response doSend(Request.Builder builder, Request request) throws Exception {
        this.authenticate(this.client, request);
        this.setProtocols(this.client, request);
        this.addHeaders(builder, request);
        OkHttpClient client = this.getClient(request.getConnectionTimeout(), request.isFollowRedirects());
        Call call = client.newCall(builder.build());
        Callback callback = request.getCallback();
        if (callback == null) {
            return new Response(call.execute());
        }
        this.sendAsync(call, callback);
        return null;
    }

    protected OkHttpClient getClient(int connectionTimeout, boolean followRedirects) {
        OkHttpClient clone = this.client.clone();
        clone.setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        clone.setReadTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        clone.setWriteTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        clone.setFollowRedirects(followRedirects);
        return clone;
    }

    protected RequestBody getUploadBody(Request request) {
        JSONObject body = (JSONObject)request.getBody();
        Object tag = request.getTag();
        MultipartBuilder builder = new MultipartBuilder().type(MultipartBuilder.FORM);
        Iterator it = body.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = body.opt(key);
            if (value instanceof UploadData) {
                UploadData data = (UploadData)value;
                InputStreamBody requestBody = new InputStreamBody(data, tag);
                builder.addFormDataPart(key, data.getFileName(), (RequestBody)requestBody);
                continue;
            }
            builder.addFormDataPart(key, value.toString());
        }
        return builder.build();
    }

    protected Response send(Request.Builder builder, final Request request) throws Exception {
        final Request.Builder finalBuilder = builder.url(request.getURL());
        builder.tag(request.getTag());
        final Callback callback = request.getCallback();
        Session session = this.getSessionFromRequest(request);
        AuthenticationRefreshHandler refreshHandler = this.refreshHandlerFactory.refreshHandlerForAuthentication(request.getAuthentication());
        if (request.getCallback() == null) {
            Session refreshSession = refreshHandler.refreshAuthentication(session, null);
            request.setAuthentication(refreshSession.getAuthentication());
            return this.doSend(builder, request);
        }
        refreshHandler.refreshAuthentication(session, new SessionCallback(){

            @Override
            public void onSuccess(Session session) {
                try {
                    request.setAuthentication(session.getAuthentication());
                    OkHttpClientImpl.this.doSend(finalBuilder, request);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                callback.doFailure(e);
            }
        });
        return null;
    }

    protected void sendAsync(Call call, final Callback callback) {
        call.enqueue(new com.squareup.okhttp.Callback(){

            public void onFailure(com.squareup.okhttp.Request request, IOException ioe) {
                callback.doFailure(ioe);
            }

            public void onResponse(com.squareup.okhttp.Response response) throws IOException {
                callback.inBackground(new Response(response));
            }
        });
    }

    protected String getServerURL(String url) {
        if (url.contains("/api/jsonws/invoke")) {
            url = url.substring(0, url.indexOf("/api/jsonws/invoke"));
        }
        return url;
    }

    protected Session getSessionFromRequest(Request request) {
        Authentication authentication = request.getAuthentication();
        Map<String, String> headers = request.getHeaders();
        String server = this.getServerURL(request.getURL());
        SessionImpl session = new SessionImpl(server, authentication);
        session.setHeaders(headers);
        return session;
    }
}

