/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.customtabs.CustomTabsIntent;
import com.liferay.mobile.android.auth.SessionCallback;
import com.liferay.mobile.android.auth.oauth2.OAuth2Authentication;
import com.liferay.mobile.android.auth.oauth2.TokenRequester;
import com.liferay.mobile.android.service.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.openid.appauth.AuthorizationException;
import net.openid.appauth.AuthorizationRequest;
import net.openid.appauth.AuthorizationResponse;
import net.openid.appauth.AuthorizationService;
import net.openid.appauth.AuthorizationServiceConfiguration;
import net.openid.appauth.TokenRequest;

public class OAuth2SignIn {
    private static String _AUTHORIZATION_PATH = "o/oauth2/authorize";
    private static String _TOKEN_PATH = "o/oauth2/token";

    public static Session resumeAuthorizationFlowWithIntent(Context context, Session session, Intent intent, SessionCallback callback) throws Exception {
        AuthorizationResponse resp = AuthorizationResponse.fromIntent((Intent)intent);
        AuthorizationException ex = AuthorizationException.fromIntent((Intent)intent);
        if (ex != null) {
            callback.onFailure((Exception)ex);
        }
        String tokenUrl = OAuth2SignIn.getTokenUrl(session.getServer());
        TokenRequest appAuthRequest = resp.createTokenExchangeRequest();
        TokenRequester request = new TokenRequester(session, tokenUrl, appAuthRequest.clientId, null, new ArrayList<String>(), appAuthRequest.getRequestParameters());
        return request.send(callback);
    }

    public static void signInWithRedirect(Activity activity, Session session, String clientId, List<String> scopes, Uri redirectUri, CustomTabsIntent customTabsIntent) {
        AuthorizationService service = new AuthorizationService((Context)activity);
        AuthorizationServiceConfiguration config = OAuth2SignIn.getAuthorizationServiceConfiguration(session.getServer());
        AuthorizationRequest request = new AuthorizationRequest.Builder(config, clientId, "code", redirectUri).setScopes(scopes).build();
        Intent intent = customTabsIntent != null ? service.getAuthorizationRequestIntent(request, customTabsIntent) : service.getAuthorizationRequestIntent(request);
        activity.startActivityForResult(intent, 0);
    }

    public static Session signInWithUsernameAndPassword(String username, String password, Session session, String clientId, String clientSecret, List<String> scopes, SessionCallback callback) throws Exception {
        String tokenUrl = OAuth2SignIn.getTokenUrl(session.getServer());
        Map<String, String> parameters = TokenRequester.parametersUsernameAndPassword(username, password);
        TokenRequester request = new TokenRequester(session, tokenUrl, clientId, clientSecret, scopes, parameters);
        return request.send(callback);
    }

    public static Session clientCredentialsSignIn(Session session, String clientId, String clientSecret, List<String> scopes, SessionCallback callback) throws Exception {
        String tokenUrl = OAuth2SignIn.getTokenUrl(session.getServer());
        Map<String, String> parameters = TokenRequester.parametersClientCredentials();
        TokenRequester request = new TokenRequester(session, tokenUrl, clientId, clientSecret, scopes, parameters);
        return request.send(callback);
    }

    public static Session refreshToken(Session session, List<String> scopes, SessionCallback callback) throws Exception {
        if (!(session.getAuthentication() instanceof OAuth2Authentication)) {
            throw new IllegalAccessException("Authentication should be of type OAuth2Authentication");
        }
        OAuth2Authentication authentication = (OAuth2Authentication)session.getAuthentication();
        if (OAuth2SignIn.isClientCredentialsToken(authentication)) {
            return OAuth2SignIn.clientCredentialsSignIn(session, authentication.getClientId(), authentication.getClientSecret(), scopes, callback);
        }
        String tokenUrl = OAuth2SignIn.getTokenUrl(session.getServer());
        Map<String, String> parameters = TokenRequester.parametersRefresh(authentication.getRefreshToken());
        TokenRequester request = new TokenRequester(session, tokenUrl, authentication.getClientId(), authentication.getClientSecret(), scopes, parameters);
        return request.send(callback);
    }

    public static void setPaths(String tokenPath, String authorizationPath) {
        _TOKEN_PATH = tokenPath;
        _AUTHORIZATION_PATH = authorizationPath;
    }

    private static AuthorizationServiceConfiguration getAuthorizationServiceConfiguration(String server) {
        String parsedServer = OAuth2SignIn.getServerURL(server);
        Uri authorizationUri = Uri.parse((String)(parsedServer + _AUTHORIZATION_PATH));
        Uri tokenUri = Uri.parse((String)(parsedServer + _TOKEN_PATH));
        return new AuthorizationServiceConfiguration(authorizationUri, tokenUri);
    }

    private static boolean isClientCredentialsToken(OAuth2Authentication auth) {
        return auth.getRefreshToken().isEmpty();
    }

    private static String getTokenUrl(String server) {
        return OAuth2SignIn.getServerURL(server) + _TOKEN_PATH;
    }

    private static String getServerURL(String server) {
        return server.endsWith("/") ? server : server + "/";
    }
}

