/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.android.auth.refresh;

import com.liferay.mobile.android.auth.Authentication;
import com.liferay.mobile.android.auth.CookieSignIn;
import com.liferay.mobile.android.auth.SessionCallback;
import com.liferay.mobile.android.auth.basic.CookieAuthentication;
import com.liferay.mobile.android.auth.refresh.AuthenticationRefreshHandler;
import com.liferay.mobile.android.service.Session;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class CookieAuthenticationRefreshHandler
implements AuthenticationRefreshHandler {
    protected static final Semaphore semaphore = new Semaphore(1);
    private static final int TOLERANCE = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session refreshAuthentication(final Session session, final SessionCallback callback) throws Exception {
        if (CookieAuthenticationRefreshHandler.shouldCheckCookieExpiration(session.getAuthentication())) {
            CookieAuthentication authentication = (CookieAuthentication)session.getAuthentication();
            semaphore.acquire();
            if (CookieAuthenticationRefreshHandler.shouldRefreshCookie(authentication.getLastCookieRefresh(), authentication.getCookieExpirationTime())) {
                if (callback == null) {
                    try {
                        Session session2 = CookieSignIn.signIn(session);
                        return session2;
                    }
                    finally {
                        semaphore.release();
                    }
                }
                CookieSignIn.signIn(session, new CookieSignIn.CookieCallback(){

                    @Override
                    public void onSuccess(Session cookieSession) {
                        session.setAuthentication(cookieSession.getAuthentication());
                        semaphore.release();
                        callback.onSuccess(session);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        semaphore.release();
                        callback.onFailure(e);
                    }
                });
                return null;
            }
            semaphore.release();
        }
        if (callback != null) {
            callback.onSuccess(session);
            return null;
        }
        return session;
    }

    private static boolean shouldCheckCookieExpiration(Authentication authentication) {
        CookieAuthentication cookieAuthentication;
        return authentication instanceof CookieAuthentication && (cookieAuthentication = (CookieAuthentication)authentication).shouldHandleExpiration();
    }

    private static boolean shouldRefreshCookie(long lastCookieRefresh, int cookieExpirationTime) {
        long now = System.currentTimeMillis();
        long deltaTime = TimeUnit.MILLISECONDS.toSeconds(now - lastCookieRefresh);
        return deltaTime + 60L > (long)cookieExpirationTime;
    }
}

