/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.fcm;

import com.liferay.mobile.fcm.MessageResult;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

public class Status {
    protected final List<MessageResult> failed;
    protected Response httpResponse;
    protected final long multicastId;
    protected final List<MessageResult> succeeded;

    public List<MessageResult> failed() {
        return this.failed;
    }

    public Response httpResponse() {
        return this.httpResponse;
    }

    public int httpStatusCode() {
        return this.httpResponse().code();
    }

    public boolean isSuccessful() {
        return this.httpResponse().isSuccessful();
    }

    public long multicastId() {
        return this.multicastId;
    }

    public List<MessageResult> succeeded() {
        return this.succeeded;
    }

    protected void httpResponse(Response httpResponse) {
        this.httpResponse = httpResponse;
    }

    protected Status(Builder builder) {
        this.failed = builder.failed;
        this.multicastId = builder.multicastId;
        this.succeeded = builder.succeeded;
    }

    public static class Builder {
        final List<MessageResult> failed = new ArrayList<MessageResult>();
        long multicastId;
        final List<MessageResult> succeeded = new ArrayList<MessageResult>();

        public Builder addFailure(MessageResult failure) {
            this.failed.add(failure);
            return this;
        }

        public Builder addSuccess(MessageResult success) {
            this.succeeded.add(success);
            return this;
        }

        public Builder multicastId(long multicastId) {
            this.multicastId = multicastId;
            return this;
        }

        public Status build() {
            return new Status(this);
        }
    }
}

