/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework;

import com.google.common.base.Function;
import com.liferay.gs.testFramework.Selenium;
import com.liferay.gs.testFramework.UtilsKeys;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Wait;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WaitUtils {
    private static WebDriverWait waitDriver = null;
    private static Wait<WebDriver> waitFluent = null;

    public static void waitShortTime() {
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitMediumTime() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitLongTime() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @SafeVarargs
    public static <R> WebElement findElementWithWaitDriver(By elementLocator, java.util.function.Function<By, ExpectedCondition<R>> ... expectedConditions) {
        WaitUtils.applyWaits(elementLocator, (Wait<WebDriver>)WaitUtils.getWaitDriver(), expectedConditions);
        WebElement element = Selenium.getDriver().findElement(elementLocator);
        return element;
    }

    private static <R> void applyWaits(By elementLocator, Wait<WebDriver> wait, java.util.function.Function<By, ExpectedCondition<R>>[] expectedConditions) {
        for (java.util.function.Function<By, ExpectedCondition<R>> condition : expectedConditions) {
            wait.until((Function)condition.apply(elementLocator));
        }
    }

    @SafeVarargs
    public static <R> WebElement findElementWithFluentWait(By elementLocator, java.util.function.Function<By, ExpectedCondition<R>> ... expectedConditions) {
        WaitUtils.applyWaits(elementLocator, WaitUtils.getFluentWait(), expectedConditions);
        WebElement element = Selenium.getDriver().findElement(elementLocator);
        return element;
    }

    public static WebDriverWait getWaitDriver() {
        if (waitDriver == null) {
            waitDriver = new WebDriverWait(Selenium.getDriver(), (long)UtilsKeys.getTimeOut());
        }
        return waitDriver;
    }

    public static Wait<WebDriver> getFluentWait() {
        if (waitFluent == null) {
            waitFluent = new FluentWait((Object)Selenium.getDriver()).withTimeout((long)UtilsKeys.getTimeOut(), TimeUnit.SECONDS).pollingEvery(1L, TimeUnit.SECONDS).ignoring(NoSuchElementException.class).ignoring(StaleElementReferenceException.class);
        }
        return waitFluent;
    }
}

