/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gs.testFramework;

import com.liferay.gs.testFramework.ConfigurationOS;
import com.liferay.gs.testFramework.SeleniumReadPropertyKeys;
import com.liferay.gs.testFramework.SeleniumWaitMethods;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.imageio.ImageIO;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class SeleniumCommonMethods {
    private static String imagePath = null;
    private static Actions actionBuilder = new Actions(SeleniumReadPropertyKeys.DRIVER);
    private static final By addButtonLocator = By.xpath((String)".//*[@id='_com_liferay_product_navigation_control_menu_web_portlet_ProductNavigationControlMenuPortlet_addToggleId']");
    private static final By applicationHeadingLocator = By.xpath((String)".//*[@id='_com_liferay_product_navigation_control_menu_web_portlet_ProductNavigationControlMenuPortlet_addApplicationHeading']");
    private static final By searchApplicationLocator = By.xpath((String)".//*[@id='_com_liferay_product_navigation_control_menu_web_portlet_ProductNavigationControlMenuPortlet_searchApplication']");

    public static void setPathToAttachFile(String imageExtension) {
        Date data = new Date();
        if (SeleniumReadPropertyKeys.getDefaultPlatformName().contains("default")) {
            try {
                Thread.sleep(1000L);
                new File("reports/screenshots/").mkdirs();
                imagePath = "Screenshot_" + data.getTime() + "-screenshot." + imageExtension;
                BufferedImage image = new Robot().createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
                ImageIO.write((RenderedImage)image, imageExtension, new File("reports/screenshots/" + imagePath));
            }
            catch (Exception e) {
                System.out.println(e);
            }
        } else {
            Random numberGenerator = new Random();
            String pathToSaveTheFile = SeleniumReadPropertyKeys.getAttachFilePath();
            int number = numberGenerator.nextInt(5) + 1;
            imagePath = pathToSaveTheFile + "0" + number + "." + imageExtension;
        }
    }

    public static String getPathOfImageFile() {
        if (SeleniumReadPropertyKeys.getDefaultPlatformName().contains("default")) {
            Path whereIam = Paths.get(ConfigurationOS.class.getResource("/").getFile(), new String[0]);
            Path rootRepository = whereIam.getParent();
            return rootRepository + "/reports/screenshots/" + imagePath;
        }
        return imagePath;
    }

    public static void removeScreenshots() {
        Path whereIam;
        Path rootRepository;
        File folder;
        if (SeleniumReadPropertyKeys.getDefaultPlatformName().contains("default") && (folder = new File(imagePath = (rootRepository = (whereIam = Paths.get(ConfigurationOS.class.getResource("/").getFile(), new String[0])).getParent()) + "/reports/screenshots/")).exists() && folder.listFiles().length > 0) {
            File[] files;
            for (File file : files = folder.listFiles()) {
                if (!file.getName().startsWith("Screenshot_")) continue;
                file.delete();
            }
        }
    }

    public static void addPortletOnScreen(String portletName, String column) {
        SeleniumCommonMethods.clickOnAddButton();
        SeleniumCommonMethods.clickOnApplicationCategory();
        SeleniumCommonMethods.searchForPortletByName(portletName);
        SeleniumCommonMethods.dragAndDropPortletToColumn(portletName, column);
    }

    public static void removeAllPorlets() {
        List portlets = SeleniumReadPropertyKeys.DRIVER.findElements(By.cssSelector((String)".portlet-layout .portlet"));
        for (WebElement portlet : portlets) {
            SeleniumCommonMethods.openPortletActionDropDown(portlet);
            SeleniumCommonMethods.clickOnPortletConfigurationMenu("Remove");
            SeleniumCommonMethods.acceptBrowserDialog();
        }
    }

    public static void removeAllSpecificPorlets(String partOfPortletID) {
        List portlets = SeleniumReadPropertyKeys.DRIVER.findElements(By.xpath((String)(".//*[contains(@id,'" + partOfPortletID + "')]")));
        for (WebElement portlet : portlets) {
            SeleniumCommonMethods.openPortletActionDropDown(portlet);
            SeleniumCommonMethods.clickOnPortletConfigurationMenu("Remove");
            SeleniumCommonMethods.acceptBrowserDialog();
        }
    }

    private static void dragAndDropPortletToColumn(String portletName, String column) {
        SeleniumWaitMethods.waitMediumTime();
        By searchApplicationResultLocator = By.xpath((String)(".//*[@id='_com_liferay_product_navigation_control_menu_web_portlet_ProductNavigationControlMenuPortlet_portletCategory0']//*[contains (text(), '" + portletName + "')]"));
        By columnLocator = By.xpath((String)(".//*[@id='" + column + "']"));
        SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.visibilityOfElementLocated((By)searchApplicationResultLocator));
        SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.elementToBeClickable((By)searchApplicationResultLocator));
        WebElement element = SeleniumReadPropertyKeys.DRIVER.findElement(searchApplicationResultLocator);
        WebElement target = SeleniumReadPropertyKeys.DRIVER.findElement(columnLocator);
        new Actions(SeleniumReadPropertyKeys.DRIVER).dragAndDrop(element, target).perform();
        SeleniumWaitMethods.waitMediumTime();
    }

    private static void searchForPortletByName(String portletName) {
        SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.visibilityOfElementLocated((By)searchApplicationLocator));
        SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.elementToBeClickable((By)searchApplicationLocator));
        SeleniumReadPropertyKeys.DRIVER.findElement(searchApplicationLocator).sendKeys(new CharSequence[]{portletName});
    }

    private static void clickOnAddButton() {
        SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.visibilityOfElementLocated((By)addButtonLocator));
        SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.elementToBeClickable((By)addButtonLocator));
        SeleniumReadPropertyKeys.DRIVER.findElement(addButtonLocator).click();
    }

    private static void clickOnApplicationCategory() {
        SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.visibilityOfElementLocated((By)applicationHeadingLocator));
        SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.elementToBeClickable((By)applicationHeadingLocator));
        By portletContentCategories = By.cssSelector((String)".add-content-menu .lfr-content-category");
        boolean isApplicationCategoriesDisplayed = SeleniumReadPropertyKeys.DRIVER.findElement(portletContentCategories).isDisplayed();
        if (!isApplicationCategoriesDisplayed) {
            SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.visibilityOfElementLocated((By)applicationHeadingLocator));
            SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.elementToBeClickable((By)applicationHeadingLocator));
            SeleniumReadPropertyKeys.DRIVER.findElement(applicationHeadingLocator).click();
        }
    }

    private static void openPortletActionDropDown(WebElement portletElement) {
        WebElement configButton = portletElement.findElement(By.cssSelector((String)".lexicon-icon-ellipsis-v"));
        actionBuilder.moveToElement(configButton).pause(Duration.ofMillis(200L)).perform();
        configButton.click();
    }

    private static void clickOnPortletConfigurationMenu(String title) {
        By dropDownMenu = By.cssSelector((String)".dropdown-menu");
        SeleniumWaitMethods.getWaitDriver().until((Function)ExpectedConditions.visibilityOfElementLocated((By)dropDownMenu));
        WebElement dropDownMenuElement = SeleniumReadPropertyKeys.DRIVER.findElement(dropDownMenu);
        List elements = dropDownMenuElement.findElements(By.cssSelector((String)"li a.lfr-icon-item"));
        WebElement element = elements.stream().filter(el -> el.getText().trim().equals(title)).findFirst().get();
        element.click();
    }

    private static void acceptBrowserDialog() {
        Alert alert = SeleniumReadPropertyKeys.DRIVER.switchTo().alert();
        alert.accept();
    }
}

