/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.test.selenium.browser;

import com.liferay.faces.test.selenium.browser.BrowserDriver;
import com.liferay.faces.test.selenium.browser.BrowserDriverFactory;
import com.liferay.faces.test.selenium.browser.TestUtil;
import com.liferay.faces.test.selenium.browser.WaitingAsserter;
import com.liferay.faces.test.selenium.browser.WaitingAsserterFactory;
import org.junit.AfterClass;
import org.junit.Before;

public abstract class BrowserDriverManagingTesterBase {
    private static final boolean RUNNING_WITH_MAVEN = Boolean.valueOf(TestUtil.getSystemPropertyOrDefault("RUNNING_WITH_MAVEN", "false"));
    private static boolean isSetUp = false;
    private static BrowserDriver browserDriver;
    private static WaitingAsserter waitingAsserter;

    @AfterClass
    public static void tearDown() {
        if (!RUNNING_WITH_MAVEN) {
            BrowserDriverManagingTesterBase.doTearDown();
        }
    }

    protected static void doTearDown() {
        waitingAsserter = null;
        if (browserDriver != null) {
            browserDriver.quit();
            browserDriver = null;
        }
        isSetUp = false;
    }

    @Before
    public final void setUp() {
        if (!isSetUp) {
            this.doSetUp();
            isSetUp = true;
        }
    }

    protected void doSetUp() {
        TestUtil.signIn(this.getBrowserDriver());
    }

    protected final BrowserDriver getBrowserDriver() {
        if (browserDriver == null) {
            browserDriver = BrowserDriverFactory.getBrowserDriver();
        }
        return browserDriver;
    }

    protected final WaitingAsserter getWaitingAsserter() {
        if (waitingAsserter == null) {
            waitingAsserter = WaitingAsserterFactory.getWaitingAsserter(this.getBrowserDriver());
        }
        return waitingAsserter;
    }
}

