/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.treetable;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.event.CellEditEvent;
import org.primefaces.integrationtests.general.utilities.TestUtils;
import org.primefaces.integrationtests.treetable.Document;
import org.primefaces.integrationtests.treetable.DocumentService;
import org.primefaces.model.TreeNode;

@Named
@ViewScoped
public class TreeTable007
implements Serializable {
    private static final long serialVersionUID = -916573957615748882L;
    private TreeNode<Document> root;
    private Document selectedDocument;
    @Inject
    private DocumentService service;

    @PostConstruct
    public void init() {
        this.root = this.service.createDocuments();
    }

    public void resetTable() {
        TreeTable treeTable = (TreeTable)FacesContext.getCurrentInstance().getViewRoot().findComponent("form:treeTable");
        treeTable.reset();
        this.init();
    }

    public void showSelectedDocument() {
        TestUtils.addMessage((String)"selected document", (String)(this.selectedDocument.getName() + ";" + this.selectedDocument.getSize() + ";" + this.selectedDocument.getType()));
    }

    public void onCellEdit(CellEditEvent<String> event) {
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (newValue != null && !newValue.equals(oldValue)) {
            TestUtils.addMessage((String)"Cell Changed", (String)("Old: " + oldValue + ", New:" + newValue));
        }
    }

    @Generated
    public TreeTable007() {
    }

    @Generated
    public TreeNode<Document> getRoot() {
        return this.root;
    }

    @Generated
    public Document getSelectedDocument() {
        return this.selectedDocument;
    }

    @Generated
    public DocumentService getService() {
        return this.service;
    }

    @Generated
    public void setRoot(TreeNode<Document> root) {
        this.root = root;
    }

    @Generated
    public void setSelectedDocument(Document selectedDocument) {
        this.selectedDocument = selectedDocument;
    }

    @Generated
    public void setService(DocumentService service) {
        this.service = service;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeTable007)) {
            return false;
        }
        TreeTable007 other = (TreeTable007)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TreeNode this$root = this.getRoot();
        TreeNode other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        Document this$selectedDocument = this.getSelectedDocument();
        Document other$selectedDocument = other.getSelectedDocument();
        if (this$selectedDocument == null ? other$selectedDocument != null : !this$selectedDocument.equals(other$selectedDocument)) {
            return false;
        }
        DocumentService this$service = this.getService();
        DocumentService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TreeTable007;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeNode $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        Document $selectedDocument = this.getSelectedDocument();
        result = result * 59 + ($selectedDocument == null ? 43 : $selectedDocument.hashCode());
        DocumentService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TreeTable007(root=" + this.getRoot() + ", selectedDocument=" + this.getSelectedDocument() + ", service=" + this.getService() + ")";
    }
}

