/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.treetable;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.event.NodeUnselectEvent;
import org.primefaces.integrationtests.general.utilities.TestUtils;
import org.primefaces.integrationtests.treetable.Document;
import org.primefaces.integrationtests.treetable.DocumentService;
import org.primefaces.model.TreeNode;

@Named
@ViewScoped
public class TreeTable001
implements Serializable {
    private static final long serialVersionUID = 4336050122274677022L;
    private TreeNode<Document> root;
    private TreeNode<Document> selectedNode;
    private Document selectedDocument;
    private boolean otherDocuments = false;
    @Inject
    private DocumentService service;

    @PostConstruct
    public void init() {
        this.root = this.service.createDocuments();
    }

    public void resetTable() {
        TreeTable treeTable = (TreeTable)FacesContext.getCurrentInstance().getViewRoot().findComponent("form:treeTable");
        treeTable.reset();
        this.init();
    }

    public void showSelectedDocument() {
        TestUtils.addMessage((String)"selected document", (String)this.selectedDocument.getName());
    }

    public void showSelectedNode() {
        TestUtils.addMessage((String)"selected node", (String)((Document)this.selectedNode.getData()).getName());
    }

    public void selectNode(NodeSelectEvent event) {
        TestUtils.addMessage((String)"select-event", (String)((Document)event.getTreeNode().getData()).getName());
    }

    public void unselectNode(NodeUnselectEvent event) {
        TestUtils.addMessage((String)"unselect-event", (String)((Document)event.getTreeNode().getData()).getName());
    }

    public void switch2OtherDocuments() {
        this.root = this.otherDocuments ? this.service.createDocuments() : this.service.createOtherDocuments();
        this.otherDocuments = !this.otherDocuments;
        TreeTable treeTable = (TreeTable)FacesContext.getCurrentInstance().getViewRoot().findComponent("form:treeTable");
        treeTable.filterAndSort();
    }

    @Generated
    public TreeTable001() {
    }

    @Generated
    public TreeNode<Document> getRoot() {
        return this.root;
    }

    @Generated
    public TreeNode<Document> getSelectedNode() {
        return this.selectedNode;
    }

    @Generated
    public Document getSelectedDocument() {
        return this.selectedDocument;
    }

    @Generated
    public boolean isOtherDocuments() {
        return this.otherDocuments;
    }

    @Generated
    public DocumentService getService() {
        return this.service;
    }

    @Generated
    public void setRoot(TreeNode<Document> root) {
        this.root = root;
    }

    @Generated
    public void setSelectedNode(TreeNode<Document> selectedNode) {
        this.selectedNode = selectedNode;
    }

    @Generated
    public void setSelectedDocument(Document selectedDocument) {
        this.selectedDocument = selectedDocument;
    }

    @Generated
    public void setOtherDocuments(boolean otherDocuments) {
        this.otherDocuments = otherDocuments;
    }

    @Generated
    public void setService(DocumentService service) {
        this.service = service;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeTable001)) {
            return false;
        }
        TreeTable001 other = (TreeTable001)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isOtherDocuments() != other.isOtherDocuments()) {
            return false;
        }
        TreeNode this$root = this.getRoot();
        TreeNode other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        TreeNode this$selectedNode = this.getSelectedNode();
        TreeNode other$selectedNode = other.getSelectedNode();
        if (this$selectedNode == null ? other$selectedNode != null : !this$selectedNode.equals(other$selectedNode)) {
            return false;
        }
        Document this$selectedDocument = this.getSelectedDocument();
        Document other$selectedDocument = other.getSelectedDocument();
        if (this$selectedDocument == null ? other$selectedDocument != null : !this$selectedDocument.equals(other$selectedDocument)) {
            return false;
        }
        DocumentService this$service = this.getService();
        DocumentService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TreeTable001;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOtherDocuments() ? 79 : 97);
        TreeNode $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        TreeNode $selectedNode = this.getSelectedNode();
        result = result * 59 + ($selectedNode == null ? 43 : $selectedNode.hashCode());
        Document $selectedDocument = this.getSelectedDocument();
        result = result * 59 + ($selectedDocument == null ? 43 : $selectedDocument.hashCode());
        DocumentService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TreeTable001(root=" + this.getRoot() + ", selectedNode=" + this.getSelectedNode() + ", selectedDocument=" + this.getSelectedDocument() + ", otherDocuments=" + this.isOtherDocuments() + ", service=" + this.getService() + ")";
    }
}

