/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.tree;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.integrationtests.general.utilities.TestUtils;
import org.primefaces.integrationtests.tree.TreeNodeService;
import org.primefaces.model.TreeNode;

@Named
@ViewScoped
public class Tree004
implements Serializable {
    @Inject
    private TreeNodeService treeNodeService;
    private TreeNode<String> root;
    private TreeNode<String>[] selectedNodes;
    private String selection;

    @PostConstruct
    public void init() {
        this.root = this.treeNodeService.createNodes();
        this.selection = "multiple";
    }

    public void showSelectedNodes() {
        if (this.selectedNodes != null && this.selectedNodes.length > 0) {
            TestUtils.addMessage((String)"Selected nodes", (String)Arrays.stream(this.selectedNodes).map(n -> (String)n.getData()).collect(Collectors.joining(",")));
        } else {
            TestUtils.addMessage((String)"No node selected!", (String)"");
        }
    }

    public void filter(AjaxBehaviorEvent event) {
        TestUtils.addMessage((String)"filter-event");
    }

    @Generated
    public Tree004() {
    }

    @Generated
    public TreeNodeService getTreeNodeService() {
        return this.treeNodeService;
    }

    @Generated
    public TreeNode<String> getRoot() {
        return this.root;
    }

    @Generated
    public TreeNode<String>[] getSelectedNodes() {
        return this.selectedNodes;
    }

    @Generated
    public String getSelection() {
        return this.selection;
    }

    @Generated
    public void setTreeNodeService(TreeNodeService treeNodeService) {
        this.treeNodeService = treeNodeService;
    }

    @Generated
    public void setRoot(TreeNode<String> root) {
        this.root = root;
    }

    @Generated
    public void setSelectedNodes(TreeNode<String>[] selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    @Generated
    public void setSelection(String selection) {
        this.selection = selection;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tree004)) {
            return false;
        }
        Tree004 other = (Tree004)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TreeNodeService this$treeNodeService = this.getTreeNodeService();
        TreeNodeService other$treeNodeService = other.getTreeNodeService();
        if (this$treeNodeService == null ? other$treeNodeService != null : !this$treeNodeService.equals(other$treeNodeService)) {
            return false;
        }
        TreeNode this$root = this.getRoot();
        TreeNode other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSelectedNodes(), other.getSelectedNodes())) {
            return false;
        }
        String this$selection = this.getSelection();
        String other$selection = other.getSelection();
        return !(this$selection == null ? other$selection != null : !this$selection.equals(other$selection));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Tree004;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TreeNodeService $treeNodeService = this.getTreeNodeService();
        result = result * 59 + ($treeNodeService == null ? 43 : $treeNodeService.hashCode());
        TreeNode $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSelectedNodes());
        String $selection = this.getSelection();
        result = result * 59 + ($selection == null ? 43 : $selection.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Tree004(treeNodeService=" + this.getTreeNodeService() + ", root=" + this.getRoot() + ", selectedNodes=" + Arrays.deepToString(this.getSelectedNodes()) + ", selection=" + this.getSelection() + ")";
    }
}

