/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.timeline;

import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.event.timeline.TimelineRangeEvent;
import org.primefaces.event.timeline.TimelineSelectEvent;
import org.primefaces.integrationtests.general.utilities.TestUtils;
import org.primefaces.model.timeline.TimelineEvent;
import org.primefaces.model.timeline.TimelineModel;

@Named
@ViewScoped
public class Timeline001
implements Serializable {
    private static final long serialVersionUID = 3439663389646247697L;
    private TimelineModel<String, ?> model;

    @PostConstruct
    public void init() {
        this.model = new TimelineModel();
        this.model.add(TimelineEvent.builder().data((Object)"PrimeUI 1.1").startDate(LocalDate.of(2014, 6, 12)).build());
        this.model.add(TimelineEvent.builder().data((Object)"PrimeFaces 5.1.3").startDate(LocalDate.of(2014, 10, 11)).build());
        this.model.add(TimelineEvent.builder().data((Object)"PrimeUI 2.2").startDate(LocalDate.of(2015, 12, 8)).build());
        this.model.add(TimelineEvent.builder().data((Object)"Sentinel-Layout 1.1").startDate(LocalDate.of(2015, 3, 10)).build());
        this.model.add(TimelineEvent.builder().data((Object)"Spark-Layout 1.0").startDate(LocalDate.of(2015, 4, 3)).build());
        this.model.add(TimelineEvent.builder().data((Object)"Ronin-Layout 1.0").startDate(LocalDate.of(2015, 5, 15)).build());
        this.model.add(TimelineEvent.builder().data((Object)"Modena-Layout 1.0").startDate(LocalDate.of(2015, 7, 10)).build());
        this.model.add(TimelineEvent.builder().data((Object)"Rio-Layout 1.0").startDate(LocalDate.of(2015, 6, 15)).build());
        this.model.add(TimelineEvent.builder().data((Object)"Adamantium-Layout 1.0").startDate(LocalDate.of(2015, 9, 4)).build());
        this.model.add(TimelineEvent.builder().data((Object)"Titan-Layout 1.0").startDate(LocalDate.of(2015, 12, 14)).build());
        this.model.add(TimelineEvent.builder().data((Object)"Volt-Layout 1.0").startDate(LocalDate.of(2015, 10, 12)).build());
        this.model.add(TimelineEvent.builder().data((Object)"Atlas-Layout 1.0").startDate(LocalDate.of(2016, 1, 28)).build());
        this.model.add(TimelineEvent.builder().data((Object)"PrimeUI 4.1.0").startDate(LocalDate.of(2016, 2, 24)).build());
        this.model.add(TimelineEvent.builder().data((Object)"PrimeFaces 5.3.8").startDate(LocalDate.of(2016, 2, 29)).build());
        this.model.add(TimelineEvent.builder().data((Object)"PrimeNG 0.5").startDate(LocalDate.of(2016, 2, 29)).build());
    }

    public void onSelect(TimelineSelectEvent<String> event) {
        TimelineEvent timelineEvent = event.getTimelineEvent();
        TestUtils.addMessage((String)"Selected event:", (String)((String)timelineEvent.getData()));
    }

    public void onRangeChanged(TimelineRangeEvent event) {
        TestUtils.addMessage((String)"Range Changed:", (String)(event.getStartDate() + " - " + event.getEndDate()));
    }

    @Generated
    public Timeline001() {
    }

    @Generated
    public TimelineModel<String, ?> getModel() {
        return this.model;
    }

    @Generated
    public void setModel(TimelineModel<String, ?> model) {
        this.model = model;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Timeline001)) {
            return false;
        }
        Timeline001 other = (Timeline001)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TimelineModel this$model = this.getModel();
        TimelineModel other$model = other.getModel();
        return !(this$model == null ? other$model != null : !this$model.equals(other$model));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Timeline001;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TimelineModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Timeline001(model=" + this.getModel() + ")";
    }
}

