/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.selectmanymenu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.integrationtests.general.model.Driver;
import org.primefaces.integrationtests.general.service.RealDriverService;
import org.primefaces.integrationtests.general.utilities.TestUtils;

@Named
@ViewScoped
public class SelectManyMenu001
implements Serializable {
    private static final long serialVersionUID = 6576774027660483468L;
    @Inject
    private RealDriverService driverService;
    private List<Driver> drivers;
    private List<Driver> selectedDrivers;

    @PostConstruct
    public void init() {
        this.drivers = this.driverService.getDrivers();
        this.selectedDrivers = new ArrayList<Driver>(Arrays.asList((Driver)this.drivers.get(1), (Driver)this.drivers.get(2)));
    }

    public void submit() {
        if (this.selectedDrivers == null || this.selectedDrivers.isEmpty()) {
            TestUtils.addMessage((String)"no driver selected");
        } else {
            TestUtils.addMessage((String)"selected drivers", (String)this.selectedDrivers.stream().map(d -> d.getName()).collect(Collectors.joining(",")));
        }
    }

    @Generated
    public SelectManyMenu001() {
    }

    @Generated
    public RealDriverService getDriverService() {
        return this.driverService;
    }

    @Generated
    public List<Driver> getDrivers() {
        return this.drivers;
    }

    @Generated
    public List<Driver> getSelectedDrivers() {
        return this.selectedDrivers;
    }

    @Generated
    public void setDriverService(RealDriverService driverService) {
        this.driverService = driverService;
    }

    @Generated
    public void setDrivers(List<Driver> drivers) {
        this.drivers = drivers;
    }

    @Generated
    public void setSelectedDrivers(List<Driver> selectedDrivers) {
        this.selectedDrivers = selectedDrivers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelectManyMenu001)) {
            return false;
        }
        SelectManyMenu001 other = (SelectManyMenu001)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RealDriverService this$driverService = this.getDriverService();
        RealDriverService other$driverService = other.getDriverService();
        if (this$driverService == null ? other$driverService != null : !this$driverService.equals(other$driverService)) {
            return false;
        }
        List this$drivers = this.getDrivers();
        List other$drivers = other.getDrivers();
        if (this$drivers == null ? other$drivers != null : !((Object)this$drivers).equals(other$drivers)) {
            return false;
        }
        List this$selectedDrivers = this.getSelectedDrivers();
        List other$selectedDrivers = other.getSelectedDrivers();
        return !(this$selectedDrivers == null ? other$selectedDrivers != null : !((Object)this$selectedDrivers).equals(other$selectedDrivers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SelectManyMenu001;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RealDriverService $driverService = this.getDriverService();
        result = result * 59 + ($driverService == null ? 43 : $driverService.hashCode());
        List $drivers = this.getDrivers();
        result = result * 59 + ($drivers == null ? 43 : ((Object)$drivers).hashCode());
        List $selectedDrivers = this.getSelectedDrivers();
        result = result * 59 + ($selectedDrivers == null ? 43 : ((Object)$selectedDrivers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SelectManyMenu001(driverService=" + this.getDriverService() + ", drivers=" + this.getDrivers() + ", selectedDrivers=" + this.getSelectedDrivers() + ")";
    }
}

