/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.schedule;

import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.schedule.ScheduleEntryMoveEvent;
import org.primefaces.event.schedule.ScheduleEntryResizeEvent;
import org.primefaces.model.DefaultScheduleEvent;
import org.primefaces.model.DefaultScheduleModel;
import org.primefaces.model.ScheduleEvent;
import org.primefaces.model.ScheduleModel;

@Named
@ViewScoped
public class Schedule001
implements Serializable {
    private static final long serialVersionUID = 2014707183985306105L;
    private ScheduleModel eventModel;
    private String locale = "en";
    private String timeZone = "UTC";
    private String clientTimeZone = "UTC";
    private ScheduleEvent<?> event = new DefaultScheduleEvent();

    @PostConstruct
    public void init() {
        this.eventModel = new DefaultScheduleModel();
        DefaultScheduleEvent event = DefaultScheduleEvent.builder().title("Champions League Match").startDate(this.previousDay8Pm()).endDate(this.previousDay11Pm()).description("Team A vs. Team B").groupId("GroupA").build();
        this.eventModel.addEvent((ScheduleEvent)event);
        event = DefaultScheduleEvent.builder().title("Birthday Party").startDate(this.today1Pm()).endDate(this.today6Pm()).description("Aragon").overlapAllowed(true).groupId("GroupA").build();
        this.eventModel.addEvent((ScheduleEvent)event);
        event = DefaultScheduleEvent.builder().title("Breakfast at Tiffanys").startDate(this.nextDay9Am()).endDate(this.nextDay11Am()).description("all you can eat").overlapAllowed(true).groupId("GroupA").build();
        this.eventModel.addEvent((ScheduleEvent)event);
        event = DefaultScheduleEvent.builder().title("Plant the new garden stuff").startDate(this.theDayAfter3Pm()).endDate(this.fourDaysLater3pm()).description("Trees, flowers, ...").groupId("GroupB").build();
        this.eventModel.addEvent((ScheduleEvent)event);
        DefaultScheduleEvent scheduleEventAllDay = DefaultScheduleEvent.builder().title("Holidays (AllDay)").startDate(this.sevenDaysLater0am()).endDate(this.eightDaysLater0am()).description("sleep as long as you want").groupId("GroupB").allDay(true).build();
        this.eventModel.addEvent((ScheduleEvent)scheduleEventAllDay);
    }

    private LocalDateTime now() {
        LocalDateTime now = LocalDateTime.now();
        if (now.getDayOfMonth() > 1) {
            return now;
        }
        return LocalDateTime.now().plusDays(1L);
    }

    private LocalDateTime previousDay8Pm() {
        return this.now().minusDays(1L).withHour(20).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime previousDay11Pm() {
        return this.now().minusDays(1L).withHour(23).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime today1Pm() {
        return this.now().withHour(13).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime theDayAfter3Pm() {
        return this.now().plusDays(1L).withHour(15).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime today6Pm() {
        return this.now().withHour(18).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime nextDay9Am() {
        return this.now().plusDays(1L).withHour(9).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime nextDay11Am() {
        return this.now().plusDays(1L).withHour(11).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime fourDaysLater3pm() {
        return this.now().plusDays(4L).withHour(15).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime sevenDaysLater0am() {
        return this.now().plusDays(7L).withHour(0).withMinute(0).withSecond(0).withNano(0);
    }

    private LocalDateTime eightDaysLater0am() {
        return this.now().plusDays(7L).withHour(0).withMinute(0).withSecond(0).withNano(0);
    }

    public void onEventSelect(SelectEvent<ScheduleEvent<LocalDateTime>> selectEvent) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Event selected", ((ScheduleEvent)selectEvent.getObject()).getGroupId() + ": " + ((ScheduleEvent)selectEvent.getObject()).getTitle());
        this.addMessage(message);
        this.setEvent((ScheduleEvent)selectEvent.getObject());
    }

    public void onDateSelect(SelectEvent<LocalDateTime> selectEvent) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Date selected", ((LocalDateTime)selectEvent.getObject()).toString());
        this.addMessage(message);
        this.event = DefaultScheduleEvent.builder().startDate((LocalDateTime)selectEvent.getObject()).endDate(((LocalDateTime)selectEvent.getObject()).plusHours(1L)).build();
    }

    public void onEventMove(ScheduleEntryMoveEvent event) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Event moved", "Delta:" + event.getDeltaAsDuration());
        this.addMessage(message);
    }

    public void onEventResize(ScheduleEntryResizeEvent event) {
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, "Event resized", "Start-Delta:" + event.getDeltaStartAsDuration() + ", End-Delta: " + event.getDeltaEndAsDuration());
        this.addMessage(message);
    }

    public void english() {
        this.setLocale("en");
    }

    public void french() {
        this.setLocale("fr");
    }

    public void german() {
        this.setLocale("de");
    }

    private void addMessage(FacesMessage message) {
        FacesContext.getCurrentInstance().addMessage(null, message);
    }

    public void deleteAllEvents() {
        this.eventModel = new DefaultScheduleModel();
    }

    @Generated
    public Schedule001() {
    }

    @Generated
    public ScheduleModel getEventModel() {
        return this.eventModel;
    }

    @Generated
    public String getLocale() {
        return this.locale;
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public String getClientTimeZone() {
        return this.clientTimeZone;
    }

    @Generated
    public ScheduleEvent<?> getEvent() {
        return this.event;
    }

    @Generated
    public void setEventModel(ScheduleModel eventModel) {
        this.eventModel = eventModel;
    }

    @Generated
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Generated
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @Generated
    public void setClientTimeZone(String clientTimeZone) {
        this.clientTimeZone = clientTimeZone;
    }

    @Generated
    public void setEvent(ScheduleEvent<?> event) {
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Schedule001)) {
            return false;
        }
        Schedule001 other = (Schedule001)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ScheduleModel this$eventModel = this.getEventModel();
        ScheduleModel other$eventModel = other.getEventModel();
        if (this$eventModel == null ? other$eventModel != null : !this$eventModel.equals(other$eventModel)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$clientTimeZone = this.getClientTimeZone();
        String other$clientTimeZone = other.getClientTimeZone();
        if (this$clientTimeZone == null ? other$clientTimeZone != null : !this$clientTimeZone.equals(other$clientTimeZone)) {
            return false;
        }
        ScheduleEvent this$event = this.getEvent();
        ScheduleEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Schedule001;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScheduleModel $eventModel = this.getEventModel();
        result = result * 59 + ($eventModel == null ? 43 : $eventModel.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $clientTimeZone = this.getClientTimeZone();
        result = result * 59 + ($clientTimeZone == null ? 43 : $clientTimeZone.hashCode());
        ScheduleEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Schedule001(eventModel=" + this.getEventModel() + ", locale=" + this.getLocale() + ", timeZone=" + this.getTimeZone() + ", clientTimeZone=" + this.getClientTimeZone() + ", event=" + this.getEvent() + ")";
    }
}

