/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.general.converter;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import javax.inject.Inject;
import javax.inject.Named;
import org.primefaces.integrationtests.general.model.Driver;
import org.primefaces.integrationtests.general.service.GeneratedDriverService;

@Named
@FacesConverter(value="generatedDriverConverter")
public class GeneratedDriverConverter
implements Converter {
    @Inject
    private GeneratedDriverService driverService;

    public Object getAsObject(FacesContext fc, UIComponent uic, String value) {
        if (this.driverService == null) {
            this.driverService = (GeneratedDriverService)CDI.current().select(GeneratedDriverService.class, new Annotation[0]).get();
        }
        if (value != null && value.trim().length() > 0) {
            try {
                int id = Integer.parseInt(value);
                return this.driverService.getDrivers().stream().filter(d -> d.getId() == id).findFirst().get();
            }
            catch (NumberFormatException e) {
                throw new ConverterException(new FacesMessage(FacesMessage.SEVERITY_ERROR, "Conversion Error", "Not a valid driver."));
            }
        }
        return null;
    }

    public String getAsString(FacesContext fc, UIComponent uic, Object driver) {
        if (driver != null) {
            return String.valueOf(((Driver)driver).getId());
        }
        return null;
    }
}

