/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.integrationtests.datatable.Customer;
import org.primefaces.integrationtests.datatable.CustomerLazyDataModel;
import org.primefaces.integrationtests.datatable.CustomerService;
import org.primefaces.model.LazyDataModel;

@Named
@ViewScoped
public class DataTable037
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    private List<Customer> customers;
    private LazyDataModel<Customer> lazyModel;
    @Inject
    private CustomerService service;

    @PostConstruct
    public void init() {
        this.customers = this.service.getCustomers();
        this.lazyModel = new CustomerLazyDataModel(this.customers);
    }

    public LazyDataModel<Customer> getLazyModel() {
        return this.lazyModel;
    }

    public long getTotalCount(String name) {
        return this.customers.stream().filter(customer -> name.equals(customer.getRepresentative())).count();
    }

    @Generated
    public DataTable037() {
    }

    @Generated
    public List<Customer> getCustomers() {
        return this.customers;
    }

    @Generated
    public CustomerService getService() {
        return this.service;
    }

    @Generated
    public void setCustomers(List<Customer> customers) {
        this.customers = customers;
    }

    @Generated
    public void setLazyModel(LazyDataModel<Customer> lazyModel) {
        this.lazyModel = lazyModel;
    }

    @Generated
    public void setService(CustomerService service) {
        this.service = service;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable037)) {
            return false;
        }
        DataTable037 other = (DataTable037)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$customers = this.getCustomers();
        List other$customers = other.getCustomers();
        if (this$customers == null ? other$customers != null : !((Object)this$customers).equals(other$customers)) {
            return false;
        }
        LazyDataModel this$lazyModel = this.getLazyModel();
        LazyDataModel other$lazyModel = other.getLazyModel();
        if (this$lazyModel == null ? other$lazyModel != null : !this$lazyModel.equals(other$lazyModel)) {
            return false;
        }
        CustomerService this$service = this.getService();
        CustomerService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataTable037;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $customers = this.getCustomers();
        result = result * 59 + ($customers == null ? 43 : ((Object)$customers).hashCode());
        LazyDataModel $lazyModel = this.getLazyModel();
        result = result * 59 + ($lazyModel == null ? 43 : $lazyModel.hashCode());
        CustomerService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataTable037(customers=" + this.getCustomers() + ", lazyModel=" + this.getLazyModel() + ", service=" + this.getService() + ")";
    }
}

