/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.integrationtests.datatable.ProgrammingLanguage;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageService;
import org.primefaces.util.LangUtils;

@Named
@ViewScoped
public class DataTable021
implements Serializable {
    private static final long serialVersionUID = 3301604336239706575L;
    private List<ProgrammingLanguage> progLanguages;
    private List<ProgrammingLanguage> filteredProgLanguages;
    @Inject
    private ProgrammingLanguageService service;

    @PostConstruct
    public void init() {
        this.progLanguages = this.service.getLangs();
    }

    public void resetTable() {
        DataTable dataTable = (DataTable)FacesContext.getCurrentInstance().getViewRoot().findComponent("form:datatable");
        dataTable.reset();
        this.progLanguages = this.service.getLangs();
    }

    public void removeV1(ProgrammingLanguage programmingLanguage) {
        this.progLanguages.remove(programmingLanguage);
        if (this.filteredProgLanguages != null) {
            this.filteredProgLanguages.remove(programmingLanguage);
        }
    }

    public void removeV2(ProgrammingLanguage programmingLanguage) {
        this.progLanguages.remove(programmingLanguage);
        DataTable dataTable = (DataTable)FacesContext.getCurrentInstance().getViewRoot().findComponent("form:datatable");
        dataTable.filterAndSort();
    }

    public void add() {
        ProgrammingLanguage programmingLanguage = new ProgrammingLanguage();
        programmingLanguage.setId(Integer.valueOf(999));
        programmingLanguage.setName("Java " + LocalDateTime.now().toString());
        programmingLanguage.setFirstAppeared(Integer.valueOf(2020));
        programmingLanguage.setType(ProgrammingLanguage.ProgrammingLanguageType.COMPILED);
        this.progLanguages.add(programmingLanguage);
        if (this.filteredProgLanguages != null) {
            this.filteredProgLanguages.add(programmingLanguage);
        }
    }

    public void deleteJavaProgrammingLanguage() {
        ProgrammingLanguage java = this.progLanguages.stream().filter(l -> l.getName().equals("Java")).findFirst().get();
        this.progLanguages.remove(java);
        DataTable dataTable = (DataTable)FacesContext.getCurrentInstance().getViewRoot().findComponent("form:datatable");
        dataTable.filterAndSort();
    }

    public boolean globalFilterFunction(Object value, Object filter, Locale locale) {
        String filterText;
        String string = filterText = filter == null ? null : filter.toString().trim().toLowerCase();
        if (LangUtils.isBlank((String)filterText)) {
            return true;
        }
        ProgrammingLanguage programmingLanguage = (ProgrammingLanguage)value;
        return programmingLanguage.getName().toLowerCase().contains(filterText) || programmingLanguage.getType().toString().toLowerCase().contains(filterText);
    }

    @Generated
    public DataTable021() {
    }

    @Generated
    public List<ProgrammingLanguage> getProgLanguages() {
        return this.progLanguages;
    }

    @Generated
    public List<ProgrammingLanguage> getFilteredProgLanguages() {
        return this.filteredProgLanguages;
    }

    @Generated
    public ProgrammingLanguageService getService() {
        return this.service;
    }

    @Generated
    public void setProgLanguages(List<ProgrammingLanguage> progLanguages) {
        this.progLanguages = progLanguages;
    }

    @Generated
    public void setFilteredProgLanguages(List<ProgrammingLanguage> filteredProgLanguages) {
        this.filteredProgLanguages = filteredProgLanguages;
    }

    @Generated
    public void setService(ProgrammingLanguageService service) {
        this.service = service;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable021)) {
            return false;
        }
        DataTable021 other = (DataTable021)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$progLanguages = this.getProgLanguages();
        List other$progLanguages = other.getProgLanguages();
        if (this$progLanguages == null ? other$progLanguages != null : !((Object)this$progLanguages).equals(other$progLanguages)) {
            return false;
        }
        List this$filteredProgLanguages = this.getFilteredProgLanguages();
        List other$filteredProgLanguages = other.getFilteredProgLanguages();
        if (this$filteredProgLanguages == null ? other$filteredProgLanguages != null : !((Object)this$filteredProgLanguages).equals(other$filteredProgLanguages)) {
            return false;
        }
        ProgrammingLanguageService this$service = this.getService();
        ProgrammingLanguageService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataTable021;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $progLanguages = this.getProgLanguages();
        result = result * 59 + ($progLanguages == null ? 43 : ((Object)$progLanguages).hashCode());
        List $filteredProgLanguages = this.getFilteredProgLanguages();
        result = result * 59 + ($filteredProgLanguages == null ? 43 : ((Object)$filteredProgLanguages).hashCode());
        ProgrammingLanguageService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataTable021(progLanguages=" + this.getProgLanguages() + ", filteredProgLanguages=" + this.getFilteredProgLanguages() + ", service=" + this.getService() + ")";
    }
}

