/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.integrationtests.datatable.ProgrammingLanguage;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageService;

@Named
@ViewScoped
public class DataTable010
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    private List<ProgrammingLanguage> progLanguages;
    private List<ProgrammingLanguage> selectedProgLanguages;
    @Inject
    private ProgrammingLanguageService service;

    @PostConstruct
    public void init() {
        this.progLanguages = this.service.getLangs();
    }

    public void submit() {
        if (this.selectedProgLanguages != null) {
            FacesMessage msg = new FacesMessage("Selected ProgrammingLanguage(s)", this.selectedProgLanguages.stream().sorted((l1, l2) -> l1.getId().compareTo(l2.getId())).map(lang -> lang.getId().toString()).collect(Collectors.joining(",")));
            FacesContext.getCurrentInstance().addMessage(null, msg);
        }
    }

    public void deleteRow() {
        ProgrammingLanguage programmingLanguage2Remove = this.progLanguages.stream().filter(lang -> lang.getName().equals("Java")).findFirst().get();
        boolean removed = this.progLanguages.remove(programmingLanguage2Remove);
        if (removed) {
            this.selectedProgLanguages.remove(programmingLanguage2Remove);
            FacesMessage msg = new FacesMessage("ProgrammingLanguage 'Java' removed");
            FacesContext.getCurrentInstance().addMessage(null, msg);
        }
    }

    @Generated
    public DataTable010() {
    }

    @Generated
    public List<ProgrammingLanguage> getProgLanguages() {
        return this.progLanguages;
    }

    @Generated
    public List<ProgrammingLanguage> getSelectedProgLanguages() {
        return this.selectedProgLanguages;
    }

    @Generated
    public ProgrammingLanguageService getService() {
        return this.service;
    }

    @Generated
    public void setProgLanguages(List<ProgrammingLanguage> progLanguages) {
        this.progLanguages = progLanguages;
    }

    @Generated
    public void setSelectedProgLanguages(List<ProgrammingLanguage> selectedProgLanguages) {
        this.selectedProgLanguages = selectedProgLanguages;
    }

    @Generated
    public void setService(ProgrammingLanguageService service) {
        this.service = service;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable010)) {
            return false;
        }
        DataTable010 other = (DataTable010)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$progLanguages = this.getProgLanguages();
        List other$progLanguages = other.getProgLanguages();
        if (this$progLanguages == null ? other$progLanguages != null : !((Object)this$progLanguages).equals(other$progLanguages)) {
            return false;
        }
        List this$selectedProgLanguages = this.getSelectedProgLanguages();
        List other$selectedProgLanguages = other.getSelectedProgLanguages();
        if (this$selectedProgLanguages == null ? other$selectedProgLanguages != null : !((Object)this$selectedProgLanguages).equals(other$selectedProgLanguages)) {
            return false;
        }
        ProgrammingLanguageService this$service = this.getService();
        ProgrammingLanguageService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataTable010;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $progLanguages = this.getProgLanguages();
        result = result * 59 + ($progLanguages == null ? 43 : ((Object)$progLanguages).hashCode());
        List $selectedProgLanguages = this.getSelectedProgLanguages();
        result = result * 59 + ($selectedProgLanguages == null ? 43 : ((Object)$selectedProgLanguages).hashCode());
        ProgrammingLanguageService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataTable010(progLanguages=" + this.getProgLanguages() + ", selectedProgLanguages=" + this.getSelectedProgLanguages() + ", service=" + this.getService() + ")";
    }
}

