/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.integrationtests.datatable;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.primefaces.integrationtests.datatable.ProgrammingLanguage;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageLazyDataModel;
import org.primefaces.integrationtests.datatable.ProgrammingLanguageService;
import org.primefaces.integrationtests.general.utilities.TestUtils;

@Named
@ViewScoped
public class DataTable006
implements Serializable {
    private static final long serialVersionUID = -7518459955779385834L;
    private ProgrammingLanguageLazyDataModel lazyDataModel;
    private List<ProgrammingLanguage> progLanguages;
    private List<ProgrammingLanguage> filteredProgLanguages;
    private List<ProgrammingLanguage> selectedProgLanguages;
    private boolean selectionPageOnly = true;
    private boolean lazy = false;
    private boolean paginator = true;
    @Inject
    private ProgrammingLanguageService service;

    @PostConstruct
    public void init() {
        this.progLanguages = this.service.getLangs();
        this.lazyDataModel = new ProgrammingLanguageLazyDataModel();
    }

    public void submit() {
        if (this.selectedProgLanguages != null) {
            FacesMessage msg = new FacesMessage("Selected ProgrammingLanguage(s)", this.selectedProgLanguages.stream().sorted(Comparator.comparing(ProgrammingLanguage::getId)).map(lang -> lang.getId().toString()).collect(Collectors.joining(",")));
            FacesContext.getCurrentInstance().addMessage(null, msg);
        }
    }

    public void toggleSelectPageOnly() {
        this.setSelectionPageOnly(!this.isSelectionPageOnly());
    }

    public void toggleLazyMode() {
        this.setLazy(!this.isLazy());
    }

    public void togglePaginator() {
        this.setPaginator(!this.isPaginator());
    }

    public void unselectRows() {
        this.selectedProgLanguages.clear();
        TestUtils.addMessage((String)"ProgrammingLanguages unselected via backing bean", (String)"");
    }

    @Generated
    public DataTable006() {
    }

    @Generated
    public ProgrammingLanguageLazyDataModel getLazyDataModel() {
        return this.lazyDataModel;
    }

    @Generated
    public List<ProgrammingLanguage> getProgLanguages() {
        return this.progLanguages;
    }

    @Generated
    public List<ProgrammingLanguage> getFilteredProgLanguages() {
        return this.filteredProgLanguages;
    }

    @Generated
    public List<ProgrammingLanguage> getSelectedProgLanguages() {
        return this.selectedProgLanguages;
    }

    @Generated
    public boolean isSelectionPageOnly() {
        return this.selectionPageOnly;
    }

    @Generated
    public boolean isLazy() {
        return this.lazy;
    }

    @Generated
    public boolean isPaginator() {
        return this.paginator;
    }

    @Generated
    public ProgrammingLanguageService getService() {
        return this.service;
    }

    @Generated
    public void setLazyDataModel(ProgrammingLanguageLazyDataModel lazyDataModel) {
        this.lazyDataModel = lazyDataModel;
    }

    @Generated
    public void setProgLanguages(List<ProgrammingLanguage> progLanguages) {
        this.progLanguages = progLanguages;
    }

    @Generated
    public void setFilteredProgLanguages(List<ProgrammingLanguage> filteredProgLanguages) {
        this.filteredProgLanguages = filteredProgLanguages;
    }

    @Generated
    public void setSelectedProgLanguages(List<ProgrammingLanguage> selectedProgLanguages) {
        this.selectedProgLanguages = selectedProgLanguages;
    }

    @Generated
    public void setSelectionPageOnly(boolean selectionPageOnly) {
        this.selectionPageOnly = selectionPageOnly;
    }

    @Generated
    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    @Generated
    public void setPaginator(boolean paginator) {
        this.paginator = paginator;
    }

    @Generated
    public void setService(ProgrammingLanguageService service) {
        this.service = service;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable006)) {
            return false;
        }
        DataTable006 other = (DataTable006)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isSelectionPageOnly() != other.isSelectionPageOnly()) {
            return false;
        }
        if (this.isLazy() != other.isLazy()) {
            return false;
        }
        if (this.isPaginator() != other.isPaginator()) {
            return false;
        }
        ProgrammingLanguageLazyDataModel this$lazyDataModel = this.getLazyDataModel();
        ProgrammingLanguageLazyDataModel other$lazyDataModel = other.getLazyDataModel();
        if (this$lazyDataModel == null ? other$lazyDataModel != null : !this$lazyDataModel.equals(other$lazyDataModel)) {
            return false;
        }
        List this$progLanguages = this.getProgLanguages();
        List other$progLanguages = other.getProgLanguages();
        if (this$progLanguages == null ? other$progLanguages != null : !((Object)this$progLanguages).equals(other$progLanguages)) {
            return false;
        }
        List this$filteredProgLanguages = this.getFilteredProgLanguages();
        List other$filteredProgLanguages = other.getFilteredProgLanguages();
        if (this$filteredProgLanguages == null ? other$filteredProgLanguages != null : !((Object)this$filteredProgLanguages).equals(other$filteredProgLanguages)) {
            return false;
        }
        List this$selectedProgLanguages = this.getSelectedProgLanguages();
        List other$selectedProgLanguages = other.getSelectedProgLanguages();
        if (this$selectedProgLanguages == null ? other$selectedProgLanguages != null : !((Object)this$selectedProgLanguages).equals(other$selectedProgLanguages)) {
            return false;
        }
        ProgrammingLanguageService this$service = this.getService();
        ProgrammingLanguageService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataTable006;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSelectionPageOnly() ? 79 : 97);
        result = result * 59 + (this.isLazy() ? 79 : 97);
        result = result * 59 + (this.isPaginator() ? 79 : 97);
        ProgrammingLanguageLazyDataModel $lazyDataModel = this.getLazyDataModel();
        result = result * 59 + ($lazyDataModel == null ? 43 : $lazyDataModel.hashCode());
        List $progLanguages = this.getProgLanguages();
        result = result * 59 + ($progLanguages == null ? 43 : ((Object)$progLanguages).hashCode());
        List $filteredProgLanguages = this.getFilteredProgLanguages();
        result = result * 59 + ($filteredProgLanguages == null ? 43 : ((Object)$filteredProgLanguages).hashCode());
        List $selectedProgLanguages = this.getSelectedProgLanguages();
        result = result * 59 + ($selectedProgLanguages == null ? 43 : ((Object)$selectedProgLanguages).hashCode());
        ProgrammingLanguageService $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataTable006(lazyDataModel=" + this.getLazyDataModel() + ", progLanguages=" + this.getProgLanguages() + ", filteredProgLanguages=" + this.getFilteredProgLanguages() + ", selectedProgLanguages=" + this.getSelectedProgLanguages() + ", selectionPageOnly=" + this.isSelectionPageOnly() + ", lazy=" + this.isLazy() + ", paginator=" + this.isPaginator() + ", service=" + this.getService() + ")";
    }
}

